/*
 *  Copyright (c) 2023 Rockchip Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

#ifndef _RK_AIQ_ISP_COMMON_CNR_H_
#define _RK_AIQ_ISP_COMMON_CNR_H_

#define CNR_SIGMACURVE_SEGMENT_MAX         8

typedef enum cnr_ds_mode_e {
    /*
    reg: (hw_cnrT_thumb_mode == 1)
    */
    cnr_ds_4x4_mode = 0,
    /*
    reg: (hw_cnrT_thumb_mode == 3)
    */
    cnr_ds_8x4_mode
} cnr_ds_mode_t;

typedef enum cnr_filtCfg_mode_e {
    // @note: The filter coefficients for configuring filters are generated by inputting  filter strength into the formula
    cnr_cfgByFiltStrg_mode = 0,
    // @note: The filter coefficients for configuring filters are directly input.
    cnr_cfgByFiltCoeff_mode = 1
} cnr_filtCfg_mode_t;

typedef enum cnr_hiFiltWgtZero_mode_e {
    /*
    hw_cnrT_hiFltWgt0_mode = 0
    */
    cnr_wgtIsZero_preLpfOut_mode = 0,
    /*
    hw_cnrT_hiFltWgt0_mode = 1
    */
    cnr_wgtIsZero_orgOut_mode = 1
} cnr_hiFiltWgtZero_mode_t;

typedef enum cnr_iirSgmRatio_mode_e {
    /*
    reg: (hw_cnrT_loFltGlobalSgmRatio_alpha == 0x08)
    */
    cnr_glbSgmRatio_only_mode = 0,
    /*
    reg: (hw_cnrT_loFltGlobalSgmRatio_alpha > 0x00) && (hw_cnrT_loFltGlobalSgmRatio_alpha < 0x08)
    */
    cnr_glbSgmRat_locSgmStrg_mode,
    /*
    reg: (hw_cnrT_loFltGlobalSgmRatio_alpha == 0x00)
    */
    cnr_locSgmStrg2SgmRat_mode,
} cnr_iirSgmRatio_mode_t;

typedef struct cnr_sigmaCurve_s {
    /* M4_GENERIC_DESC(
        M4_ALIAS(idx),
        M4_TYPE(u16),
        M4_UI_PARAM(data_x),
        M4_SIZE_EX(1,8),
        M4_RANGE_EX(0,4095),
        M4_DEFAULT([0, 64, 128, 256, 384, 640, 896, 1024]),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(0),
        M4_NOTES(TODO.\n
        Freq of use: high))  */
    uint16_t idx[CNR_SIGMACURVE_SEGMENT_MAX];
    /* M4_GENERIC_DESC(
       M4_ALIAS(val),
       M4_TYPE(f32),
       M4_UI_PARAM(data_y),
       M4_SIZE_EX(1,8),
       M4_RANGE_EX(0,1.0),
       M4_DEFAULT([0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03]),
       M4_HIDE_EX(0),
       M4_RO(0),
       M4_ORDER(1),
       M4_NOTES(TODO.\n
       Freq of use: high))  */
    float val[CNR_SIGMACURVE_SEGMENT_MAX];
} cnr_sigmaCurve_t;

typedef struct cnr_locSgmStrg_dyn_s {
    /* M4_GENERIC_DESC(
        M4_ALIAS(sw_cnrT_global_gain),
        M4_TYPE(f32),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0,64.0),
        M4_DEFAULT(1.0),
        M4_DIGIT_EX(2),
        M4_FP_EX(0,6,4),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_NOTES(The value of the global input pix sigma.\n
        Higher the value, the higher the global input pix sigma value.\n
        Freq of use: low))  */
    // @reg: sw_cnrT_global_gain
    float hw_cnrT_glbSgmStrg_val;
    /* M4_GENERIC_DESC(
        M4_ALIAS(sw_cnrT_global_gain_alpha),
        M4_TYPE(f32),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0,1.0),
        M4_DEFAULT(0.0),
        M4_DIGIT_EX(2),
        M4_FP_EX(0,1,3),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(2),
        M4_NOTES(The wgt of the global input pix sigma is used in the fusion operation with the local input pix sigma.\n
        Freq of use: low))  */
    // @reg: sw_cnrT_global_gain_alpha
    float hw_cnrT_glbSgmStrg_alpha;
    /* M4_GENERIC_DESC(
        M4_ALIAS(sw_sharp_local_gainscale),
        M4_TYPE(f32),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0,1.0),
        M4_DEFAULT(1.0),
        M4_DIGIT_EX(2),
        M4_FP_EX(0,1,7),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_NOTES(The scaling factor of the local input pix sigma.\n
        Higher the value, the higher the local input pix sigma value.\n
        Freq of use: high))  */
    // @reg: sw_sharp_local_gainscale
    float hw_cnrT_locSgmStrg_scale;
} cnr_locSgmStrg_dyn_t;

typedef struct cnr_loNr_preProc_s {
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_cnrT_thumb_mode),
        M4_TYPE(enum),
        M4_ENUM_DEF(cnr_ds_mode_t),
        M4_DEFAULT(cnr_ds_8x4_mode),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(0),
        M4_NOTES(TODO.\n
        Reference enum types.\n
        Freq of use: low))  */
    // @reg: hw_cnrT_thumb_mode
    cnr_ds_mode_t hw_cnrT_ds_mode;
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_cnrT_loFltUV_gain),
        M4_TYPE(f32),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0.0, 0.5),
        M4_DEFAULT(0.333),
        M4_DIGIT_EX(2f8b),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(0),
        M4_NOTES(TODO.\n
        Freq of use: high))  */
    // @reg: hw_cnrT_loFltUV_gain
    float hw_cnrT_uvEdg_strg;
} cnr_loNr_preProc_t;

typedef struct cnr_loNr_bifilt_s {
    /* M4_GENERIC_DESC(
        M4_ALIAS(sw_cnrT_filtCfg_mode),
        M4_TYPE(enum),
        M4_ENUM_DEF(cnr_filtCfg_mode_t),
        M4_DEFAULT(cnr_cfgByFiltStrg_mode ),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(0),
        M4_GROUP_CTRL(loNr_filtCfg_mode_group),
        M4_NOTES(The config mode of bifilter for for lo-freq noise remove.\n
        Reference enum types.\n
        Freq of use: low))  */
    cnr_filtCfg_mode_t sw_cnrT_filtCfg_mode;
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_cnrT_thumbBf_strg),
        M4_TYPE(f32),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0,256.0),
        M4_DEFAULT(1.0),
        M4_DIGIT_EX(2),
        M4_FP_EX(0,7,8),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_GROUP(loNr_filtCfg_mode_group:cnr_cfgByFiltStrg_mode),
        M4_NOTES(The spatial wgt of bifilter is operator from the strength value. Only valid on sharp_cfgByFiltStrg_mode.\n
        Higher the value, the higher spatial denoise strength.\n
        Freq of use: high))  */
    // @reg: hw_cnrT_thumbBf_coeff0~hw_cnrT_thumbBf_coeff3
    float sw_cnrT_filtSpatial_strg;
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_cnrT_thumbBf_coeff),
        M4_TYPE(f32),
        M4_SIZE_EX(1,4),
        M4_RANGE_EX(0,1.0),
        M4_DEFAULT([1, 1, 1, 1]),
        M4_DIGIT_EX(3),
        M4_FP_EX(0,1,7),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_GROUP(loNr_filtCfg_mode_group:cnr_cfgByFiltCoeff_mode),
        M4_NOTES(The spatial filter kernel of bifilter . Only valid on sharp_cfgByFiltCoeff_mode.\n
        Freq of use: low))  */
    // @reg: hw_cnrT_thumbBf_coeff0~hw_cnrT_thumbBf_coeff3
    float hw_cnrT_filtSpatial_wgt[4];
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_cnrT_loBfFlt_vsigma),
        M4_TYPE(f32),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0.0, 1.0),
        M4_DEFAULT(0.0039),
        M4_DIGIT_EX(2f14b),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(0),
        M4_NOTES(The  range sigma of the bilateral filter. \n
        The higher the value, the higher the strength of lo freq reducing noise.\n
        Freq of use: high))  */
    // reg: hw_cnrT_loBfFlt_vsigmaY, hw_cnrT_loBfFlt_vsigmaUV
    float sw_cnrT_rgeSgm_val;
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_cnrT_loBfFlt_alpha),
        M4_TYPE(f32),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0.0, 1.0),
        M4_DEFAULT(1.0),
        M4_DIGIT_EX(2f10b),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(0),
        M4_NOTES(The wgt of bifilted pixel is used in the fusion operation between the filted pixel and the original pixel.\n
        Higher the value, the stronger denoise strength of bilateral filter.\n
        Freq of use: high))  */
    // reg: hw_cnrT_loBfFlt_alpha
    float hw_cnrT_bifiltOut_alpha;
} cnr_loNr_bifilt_t;

typedef struct cnr_loNr_iirFilt_s {
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_cnrT_loFlt_coeff),
        M4_TYPE(u8),
        M4_SIZE_EX(1,6),
        M4_RANGE_EX(0,1),
        M4_DEFAULT([1, 1, 1, 1, 1, 1]),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_NOTES(The spatial filter kernel of iir filter.\n
        Freq of use: low))  */
    // @reg: hw_cnrT_loFlt_coeff
    uint8_t hw_cnrT_filtSpatial_wgt[6];
    /* M4_GENERIC_DESC(
        M4_ALIAS(sw_cnrT_loFlt_vsigma),
        M4_TYPE(f32),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0.0, 1.0),
        M4_DEFAULT(0.0078),
        M4_DIGIT_EX(2f8b),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(0),
        M4_NOTES(The range sigma of the iir filter. \n
        The higher the value, the higher the strength of lo freq reducing noise.\n
        Freq of use: high))  */
    // reg: hw_cnrT_loFlt_vsigma, hw_cnrT_expX_shiftBit
    float sw_cnrT_rgeSgm_val;
    /* M4_GENERIC_DESC(
        M4_ALIAS(sw_cnrT_rgeSgmRatio_mode),
        M4_TYPE(enum),
        M4_ENUM_DEF(cnr_iirSgmRatio_mode_t),
        M4_DEFAULT(cnr_glbSgmRatio_only_mode),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(0),
        M4_NOTES(TODO.\n
        Reference enum types.\n
        Freq of use: low))  */
    cnr_iirSgmRatio_mode_t sw_cnrT_rgeSgmRatio_mode;
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_cnrT_loFltGlobalSgm_ratio),
        M4_TYPE(f32),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0.0, 4.0),
        M4_DEFAULT(1.0),
        M4_DIGIT_EX(2f4b),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(0),
        M4_NOTES(TODO.\n
        Freq of use: low))  */
    // reg: hw_cnrT_loFltGlobalSgm_ratio
    float hw_cnrT_glbSgm_ratio;
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_cnrT_loFltGlobalSgmRatio_alpha),
        M4_TYPE(f32),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0.0, 1.0),
        M4_DEFAULT(0.5),
        M4_DIGIT_EX(3f3b),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(0),
        M4_NOTES(TODO.\n
        Freq of use: low))  */
    // reg: hw_cnrT_loFltGlobalSgmRatio_alpha
    float hw_cnrT_glbSgmRatio_alpha;
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_cnrT_loFltWgt_slope),
        M4_TYPE(f32),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0.0, 8.0),
        M4_DEFAULT(1.0),
        M4_DIGIT_EX(2f7b),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(0),
        M4_NOTES(TODO.\n
        Freq of use: low))  */
    // reg: hw_cnrT_loFltWgt_slope
    float hw_cnrT_sgm2NhoodWgt_slope;
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_cnrT_loFltWgt_minThred),
        M4_TYPE(f32),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0.0, 1.0),
        M4_DEFAULT(0.333),
        M4_DIGIT_EX(2f8b),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(0),
        M4_NOTES(TODO.\n
        Freq of use: low))  */
    // reg: hw_cnrT_loFltWgt_minThred
    float hw_cnrT_nhoodWgtZero_thred;
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_cnrT_loFltWgt_maxLimit),
        M4_TYPE(f32),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0.0, 15.0),
        M4_DEFAULT(1.0),
        M4_DIGIT_EX(1f3b),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(0),
        M4_NOTES(TODO.\n
        Freq of use: high))  */
    //reg: hw_cnrT_loFltWgt_maxLimit
    float hw_cnrT_iirFiltStrg_maxLimit;
} cnr_loNr_iirFilt_t;

typedef struct cnr_hiNr_preLpf_s {
    /* M4_GENERIC_DESC(
        M4_ALIAS(sw_cnrT_filtCfg_mode),
        M4_TYPE(enum),
        M4_ENUM_DEF(cnr_filtCfg_mode_t),
        M4_DEFAULT(cnr_cfgByFiltStrg_mode ),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(0),
        M4_GROUP_CTRL(hiNr_filtCfg_mode_group),
        M4_NOTES(The config mode of bifilter for for lo-freq noise remove.\n
        Reference enum types.\n
        Freq of use: low))  */
    cnr_filtCfg_mode_t sw_cnrT_filtCfg_mode;
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_cnrT_gausFlt_strg),
        M4_TYPE(f32),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0,100.0),
        M4_DEFAULT(1.0),
        M4_DIGIT_EX(2),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_GROUP(hiNr_filtCfg_mode_group:cnr_cfgByFiltStrg_mode),
        M4_NOTES(The spatial wgt of preLpf is operator from the strength value. Only valid on cnr_cfgByFiltStrg_mode.\n
        Higher the value, the higher spatial denoise strength.\n
        Freq of use: high))  */
    // @reg: hw_cnrT_gausFlt_coeff0~hw_cnrT_gausFlt_coeff5
    float sw_cnrT_filtSpatial_strg;
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_cnrT_gausFlt_coeff),
        M4_TYPE(f32),
        M4_SIZE_EX(1,6),
        M4_RANGE_EX(0,1.0),
        M4_DEFAULT([0.1758, 0.1094, 0.0234, 0.1094, 0.0664, 0.0156]),
        M4_DIGIT_EX(3),
        M4_FP_EX(0,1,7),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_GROUP(hiNr_filtCfg_mode_group:cnr_cfgByFiltCoeff_mode),
        M4_NOTES(The spatial filter kernel of preLpf . Only valid on cnr_cfgByFiltCoeff_mode.\n
        Freq of use: low))  */
    // @reg: hw_cnrT_gausFlt_coeff0~hw_cnrT_gausFlt_coeff5
    float hw_cnrT_filtSpatial_wgt[6];
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_cnrT_gausFlt_alpha),
        M4_TYPE(f32),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0,1.0),
        M4_DEFAULT(0.0),
        M4_DIGIT_EX(3),
        M4_FP_EX(0,1,7),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_NOTES(TODO.\n
        Freq of use: high))  */
    // @reg: hw_cnrT_gausFlt_alpha
    float hw_cnrT_lpfOut_alpha;
} cnr_hiNr_preLpf_t;

typedef struct cnr_hiNr_bifilt_s {
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_cnrT_hiFiltUV_gain),
        M4_TYPE(f32),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0.0, 8.0),
        M4_DEFAULT(3.0),
        M4_DIGIT_EX(2f4b),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(0),
        M4_NOTES(TODO.\n
        Freq of use: high))  */
    // @reg: hw_cnrT_hiFiltUV_gain
    float hw_cnrT_uvEdg_strg;
    /* M4_GENERIC_DESC(
          M4_ALIAS(hw_cnrT_hiFltWgt0_mode),
        M4_TYPE(enum),
        M4_ENUM_DEF(cnr_hiFiltWgtZero_mode_t),
        M4_DEFAULT(cnr_wgtIsZero_orgOut_mode),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(0),
        M4_NOTES(TODO.\n
        Freq of use: low))  */
    //reg: hw_cnrT_hiFltWgt0_mode
    cnr_hiFiltWgtZero_mode_t hw_cnrT_filtWgtZero_mode;
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_cnrT_gainAdjHiFltSgm_ratio),
        M4_TYPE(f32),
        M4_SIZE_EX(1,13),
        M4_RANGE_EX(0.0, 4.0),
        M4_DEFAULT(1.0),
        M4_DIGIT_EX(2f6b),
        M4_HIDE_EX(0),
        M4_UI_MODULE(curve),
        M4_DATAX([1, 2, 4, 8, 16, 24, 32, 48, 64, 128, 256, 512, 1024]),
        M4_RO(0),
        M4_ORDER(0),
        M4_NOTES(TODO.\n
        Freq of use: high))  */
    // @reg: hw_cnrT_gainAdjHiFltSgm_ratio0~12
    float hw_cnrT_locSgmStrg2SgmRat_val[13];
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_cnrT_gainAdjHiFltCur_wgt),
        M4_TYPE(f32),
        M4_SIZE_EX(1,13),
        M4_RANGE_EX(0.0, 1.0),
        M4_DEFAULT(1.0),
        M4_DIGIT_EX(2f6b),
        M4_HIDE_EX(0),
        M4_UI_MODULE(curve),
        M4_DATAX([1, 2, 4, 8, 16, 24, 32, 48, 64, 128, 256, 512, 1024]),
        M4_RO(0),
        M4_ORDER(0),
        M4_NOTES(TODO.\n
        Freq of use: high))  */
    // @reg: hw_cnrT_gainAdjHiFltCur_wgt
    float hw_cnrT_locSgmStrg2CtrWgt_scale[13];
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_cnrT_hiFltWgt_minLimit),
        M4_TYPE(f32),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0.0, 1.0),
        M4_DEFAULT(0.0078),
        M4_DIGIT_EX(3f8b),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(0),
        M4_NOTES(TODO.\n
        Freq of use: low))  */
    // @reg: hw_cnrT_hiFltWgt_minLimit
    float hw_cnrT_nhoodWgt_minLimit;
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_cnrT_satAdj_offset),
        M4_TYPE(f32),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0.0, 511.0),
        M4_DEFAULT(0.0),
        M4_DIGIT_EX(2f6b),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(0),
        M4_NOTES(TODO.\n
        Freq of use: low))  */
    // @reg: hw_cnrT_satAdj_offset
    float hw_cnrT_satAdj_offset;
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_cnrT_satAdj_scale),
        M4_TYPE(f32),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0.0, 32.0),
        M4_DEFAULT(0.0),
        M4_DIGIT_EX(3f10b),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(0),
        M4_NOTES(TODO.\n
        Freq of use: low))  */
    // @reg: hw_cnrT_satAdj_scale
    float hw_cnrT_satAdj_scale;
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_cnrT_hiFlt_alpha),
        M4_TYPE(f32),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0.0, 1.0),
        M4_DEFAULT(1.0),
        M4_DIGIT_EX(2f6b),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(0),
        M4_NOTES(TODO.\n
        Freq of use: high))  */
    // @reg: hw_cnrT_hiFlt_alpha
    float hw_cnrT_bifiltOut_alpha;
} cnr_hiNr_bifilt_t;

#endif

