# This file was created by configpm when Perl was built. Any changes
# made to this file will be lost the next time perl is built.

package Config;
use strict;
use warnings;
our %Config;

sub bincompat_options {
    return split ' ', (Internals::V())[0];
}

sub non_bincompat_options {
    return split ' ', (Internals::V())[1];
}

sub compile_date {
    return (Internals::V())[2]
}

sub local_patches {
    my (undef, undef, undef, @patches) = Internals::V();
    return @patches;
}

sub _V {
    die "Perl lib was built for 'linux' but is being run on '$^O'"
        unless "linux" eq $^O;

    my ($bincompat, $non_bincompat, $date, @patches) = Internals::V();

    my @opts = sort split ' ', "$bincompat $non_bincompat";

    print Config::myconfig();
    print "\nCharacteristics of this binary (from libperl): \n";

    print "  Compile-time options:\n";
    print "    $_\n" for @opts;

    if (@patches) {
        print "  Locally applied patches:\n";
        print "    $_\n" foreach @patches;
    }

    print "  Built under linux\n";

    print "  $date\n" if defined $date;

    my @env = map { "$_=\"$ENV{$_}\"" } sort grep {/^PERL/} keys %ENV;

    if (@env) {
        print "  \%ENV:\n";
        print "    $_\n" foreach @env;
    }
    print "  \@INC:\n";
    print "    $_\n" foreach @INC;
}

sub header_files {
    return qw(EXTERN.h INTERN.h XSUB.h av.h config.h cop.h cv.h
              dosish.h embed.h embedvar.h form.h gv.h handy.h hv.h hv_func.h
              intrpvar.h iperlsys.h keywords.h mg.h nostdio.h op.h opcode.h
              pad.h parser.h patchlevel.h perl.h perlio.h perliol.h perlsdio.h
              perlvars.h perly.h pp.h pp_proto.h proto.h regcomp.h regexp.h
              regnodes.h scope.h sv.h thread.h time64.h unixish.h utf8.h
              util.h);
}

#

our $summary = <<'!END!';
Summary of my $package (revision $revision $version_patchlevel_string) configuration:
  $git_commit_id_title $git_commit_id$git_ancestor_line
  Platform:
    osname=$osname
    osvers=$osvers
    archname=$archname
    uname='$myuname'
    config_args='$config_args'
    hint=$hint
    useposix=$useposix
    d_sigaction=$d_sigaction
    useithreads=$useithreads
    usemultiplicity=$usemultiplicity
    use64bitint=$use64bitint
    use64bitall=$use64bitall
    uselongdouble=$uselongdouble
    usemymalloc=$usemymalloc
    default_inc_excludes_dot=$default_inc_excludes_dot
    bincompat5005=undef
  Compiler:
    cc='$cc'
    ccflags ='$ccflags'
    optimize='$optimize'
    cppflags='$cppflags'
    ccversion='$ccversion'
    gccversion='$gccversion'
    gccosandvers='$gccosandvers'
    intsize=$intsize
    longsize=$longsize
    ptrsize=$ptrsize
    doublesize=$doublesize
    byteorder=$byteorder
    doublekind=$doublekind
    d_longlong=$d_longlong
    longlongsize=$longlongsize
    d_longdbl=$d_longdbl
    longdblsize=$longdblsize
    longdblkind=$longdblkind
    ivtype='$ivtype'
    ivsize=$ivsize
    nvtype='$nvtype'
    nvsize=$nvsize
    Off_t='$lseektype'
    lseeksize=$lseeksize
    alignbytes=$alignbytes
    prototype=$prototype
  Linker and Libraries:
    ld='$ld'
    ldflags ='$ldflags'
    libpth=$libpth
    libs=$libs
    perllibs=$perllibs
    libc=$libc
    so=$so
    useshrplib=$useshrplib
    libperl=$libperl
    gnulibc_version='$gnulibc_version'
  Dynamic Linking:
    dlsrc=$dlsrc
    dlext=$dlext
    d_dlsymun=$d_dlsymun
    ccdlflags='$ccdlflags'
    cccdlflags='$cccdlflags'
    lddlflags='$lddlflags'

!END!
my $summary_expanded;

sub myconfig {
    return $summary_expanded if $summary_expanded;
    ($summary_expanded = $summary) =~ s{\$(\w+)}
		 { 
			my $c;
			if ($1 eq 'git_ancestor_line') {
				if ($Config::Config{git_ancestor}) {
					$c= "\n  Ancestor: $Config::Config{git_ancestor}";
				} else {
					$c= "";
				}
			} else {
                     		$c = $Config::Config{$1}; 
			}
			defined($c) ? $c : 'undef' 
		}ge;
    $summary_expanded;
}

local *_ = \my $a;
$_ = <<'!END!';
Author=''
CONFIG='true'
Date='$Date'
Header=''
Id='$Id'
Locker=''
Log='$Log'
PATCHLEVEL='32'
PERL_API_REVISION='5'
PERL_API_SUBVERSION='0'
PERL_API_VERSION='32'
PERL_CONFIG_SH='true'
PERL_PATCHLEVEL=''
PERL_REVISION='5'
PERL_SUBVERSION='1'
PERL_VERSION='32'
RCSfile='$RCSfile'
Revision='$Revision'
SUBVERSION='1'
Source=''
State=''
_a='.a'
_exe=''
_o='.o'
afs='false'
afsroot='/afs'
alignbytes='8'
ansi2knr=''
aphostname='/bin/hostname'
api_revision='5'
api_subversion='0'
api_version='32'
api_versionstring='5.32.0'
ar='/home/ych/rk3568/buildroot/output/rockchip_rk3568/host/bin/aarch64-buildroot-linux-gnu-ar'
archlib='/usr/lib/perl5/5.32.1/aarch64-linux'
archlibexp='/usr/lib/perl5/5.32.1/aarch64-linux'
archname='aarch64-linux'
archname64=''
archobjs=''
asctime_r_proto='0'
awk='awk'
baserev='5.0'
bash='bash'
bin='/usr/bin'
bin_ELF='define'
binexp='/usr/bin'
bison='bison'
byacc='byacc'
byteorder='12345678'
c='FP_NEG_ZERO'
castflags='0'
cat='cat'
cc='/home/ych/rk3568/buildroot/output/rockchip_rk3568/host/bin/aarch64-buildroot-linux-gnu-gcc'
cccdlflags='-fPIC -Wno-unused-function'
ccdlflags='-Wl,-E'
ccflags='-D_LARGEFILE_SOURCE -D_LARGEFILE64_SOURCE -D_FILE_OFFSET_BITS=64  -Os -g0 -D_FORTIFY_SOURCE=1'
ccflags_uselargefiles=''
ccname=''
ccsymbols=''
cctype='gcc'
ccversion='12.3.0'
cf_by=''
cf_email=''
cf_time='undisclosed-time'
charbits='8'
charsize='1'
chgrp='chgrp'
chmod='chmod'
chown='chown'
clocktype='clock_t'
comm='comm'
compress=''
config_arg0='cnf/configure'
config_argc='16'
config_args='--target=aarch64-buildroot-linux-gnu --target-tools-prefix=/home/ych/rk3568/buildroot/output/rockchip_rk3568/host/bin/aarch64-buildroot-linux-gnu- --prefix=/usr -Dld=/home/ych/rk3568/buildroot/output/rockchip_rk3568/host/bin/aarch64-buildroot-linux-gnu-gcc -Dccflags=-D_LARGEFILE_SOURCE -D_LARGEFILE64_SOURCE -D_FILE_OFFSET_BITS=64  -Os -g0 -D_FORTIFY_SOURCE=1 -Dldflags= -lm  -Dmydomain= -Dmyhostname=noname -Dmyuname=Buildroot linux-5.10-gen-rkr8 -Dosname=linux -Dosvers=custom -Dperladmin=root --keeplog --mode=target --target=aarch64-buildroot-linux-gnu --targetarch=aarch64-buildroot-linux-gnu'
contains='grep'
cp='cp'
cpio='cpio'
cpp='/home/ych/rk3568/buildroot/output/rockchip_rk3568/host/bin/aarch64-buildroot-linux-gnu-gcc -E -P'
cpp_stuff='42'
cppccsymbols=''
cppflags=''
cpplast='-'
cppminus='-'
cpprun='/home/ych/rk3568/buildroot/output/rockchip_rk3568/host/bin/aarch64-buildroot-linux-gnu-gcc -E -P'
cppstdin='/home/ych/rk3568/buildroot/output/rockchip_rk3568/host/bin/aarch64-buildroot-linux-gnu-gcc -E -P'
cppsymbols=''
crypt_r_proto='0'
cryptlib=''
csh=''
ctermid_r_proto='0'
ctime_r_proto='0'
d_Gconvert='sprintf((b),"%.*g",(n),(x))'
d_PRIEUldbl='undef'
d_PRIFUldbl='undef'
d_PRIGUldbl='undef'
d_PRIXU64='undef'
d_PRId64='undef'
d_PRIeldbl='undef'
d_PRIfldbl='undef'
d_PRIgldbl='undef'
d_PRIi64='undef'
d_PRIo64='undef'
d_PRIu64='undef'
d_PRIx64='undef'
d_SCNfldbl='undef'
d__fwalk='undef'
d_accept4='define'
d_access='define'
d_accessx='undef'
d_acosh='define'
d_aintl='undef'
d_alarm='define'
d_archlib='define'
d_asctime64='undef'
d_asctime_r='undef'
d_asinh='define'
d_atanh='define'
d_atolf='undef'
d_atoll='define'
d_attribute_always_inline='define'
d_attribute_deprecated='define'
d_attribute_format='define'
d_attribute_malloc='define'
d_attribute_nonnull='define'
d_attribute_noreturn='define'
d_attribute_pure='define'
d_attribute_unused='define'
d_attribute_used='define'
d_attribute_warn_unused_result='define'
d_backtrace='define'
d_bcmp='define'
d_bcopy='define'
d_bsd='undef'
d_bsdgetpgrp='undef'
d_bsdsetpgrp='undef'
d_builtin_add_overflow='define'
d_builtin_arith_overflow='define'
d_builtin_choose_expr='define'
d_builtin_clz='define'
d_builtin_ctz='define'
d_builtin_expect='define'
d_builtin_mul_overflow='define'
d_builtin_prefetch='define'
d_builtin_sub_overflow='define'
d_bzero='define'
d_c99_variadic_macros='define'
d_casti32='undef'
d_castneg='define'
d_cbrt='define'
d_charvspr='undef'
d_chown='define'
d_chroot='define'
d_chsize='undef'
d_class='undef'
d_clearenv='define'
d_clock='define'
d_clock_getres='define'
d_clock_gettime='define'
d_clock_nanosleep='define'
d_clock_t='define'
d_closedir='define'
d_cmsghdr_s='define'
d_const='define'
d_copysign='define'
d_copysignl='define'
d_cplusplus='undef'
d_crypt='define'
d_crypt_r='undef'
d_csh='undef'
d_ctermid='define'
d_ctermid_r='undef'
d_ctime64='undef'
d_ctime_r='undef'
d_cuserid='define'
d_dbl_dig='define'
d_dbminitproto='define'
d_difftime='define'
d_difftime64='undef'
d_dir_dd_fd='undef'
d_dirfd='define'
d_dirnamlen='undef'
d_dladdr='define'
d_dlerror='define'
d_dlopen='define'
d_dlsymun='undef'
d_dosuid='undef'
d_double_has_inf='define'
d_double_has_nan='define'
d_double_has_negative_zero='define'
d_double_has_subnormals='define'
d_double_style_cray='undef'
d_double_style_ibm='undef'
d_double_style_ieee='define'
d_double_style_vax='undef'
d_drand48='define'
d_drand48_r='undef'
d_drand48proto='define'
d_dup2='define'
d_dup3='define'
d_duplocale='define'
d_eaccess='define'
d_endgrent='define'
d_endgrent_r='undef'
d_endhent='define'
d_endhostent_r='undef'
d_endnent='define'
d_endnetent_r='undef'
d_endpent='define'
d_endprotoent_r='undef'
d_endpwent='define'
d_endpwent_r='undef'
d_endsent='define'
d_endservent='define'
d_endservent_r='undef'
d_eofnblk='define'
d_erf='define'
d_erfc='define'
d_eunice='undef'
d_exp2='define'
d_expm1='define'
d_faststdio='undef'
d_fchdir='define'
d_fchmod='define'
d_fchmodat='define'
d_fchown='define'
d_fcntl='define'
d_fcntl_can_lock='define'
d_fd_macros='define'
d_fd_set='define'
d_fdclose='undef'
d_fdim='define'
d_fds_bits='undef'
d_fegetround='define'
d_fgetpos='define'
d_finite='define'
d_finitel='define'
d_flexfnam='define'
d_flock='define'
d_flockproto='define'
d_fma='define'
d_fmax='define'
d_fmin='define'
d_fork='define'
d_fp_class='undef'
d_fp_classify='undef'
d_fp_classl='undef'
d_fpathconf='define'
d_fpclass='undef'
d_fpclassify='define'
d_fpclassl='undef'
d_fpgetround='undef'
d_fpos64_t='define'
d_freelocale='define'
d_frexpl='define'
d_fs_data_s='undef'
d_fseeko='define'
d_fsetpos='define'
d_fstatfs='define'
d_fstatvfs='define'
d_fsync='define'
d_ftello='define'
d_ftime='undef'
d_futimes='define'
d_gai_strerror='define'
d_gdbm_ndbm_h_uses_prototypes='define'
d_gdbmndbm_h_uses_prototypes='define'
d_get_current_dir_name='define'
d_getaddrinfo='define'
d_getcwd='define'
d_getenv_preserves_other_thread='undef'
d_getespwnam='undef'
d_getfsstat='undef'
d_getgrent='define'
d_getgrent_r='undef'
d_getgrgid_r='undef'
d_getgrnam_r='undef'
d_getgrps='define'
d_gethbyaddr='define'
d_gethbyname='define'
d_gethent='define'
d_gethname='define'
d_gethostbyaddr_r='undef'
d_gethostbyname_r='undef'
d_gethostent_r='undef'
d_gethostprotos='define'
d_getitimer='define'
d_getlogin='define'
d_getlogin_r='undef'
d_getmnt='undef'
d_getmntent='define'
d_getnameinfo='define'
d_getnbyaddr='define'
d_getnbyname='define'
d_getnent='define'
d_getnetbyaddr='define'
d_getnetbyaddr_r='undef'
d_getnetbyname='define'
d_getnetbyname_r='undef'
d_getnetent_r='undef'
d_getnetprotos='define'
d_getpagsz='define'
d_getpbyaddr='undef'
d_getpbyname='define'
d_getpbynumber='define'
d_getpent='define'
d_getpgid='define'
d_getpgrp='define'
d_getpgrp2='undef'
d_getppid='define'
d_getprior='define'
d_getprotobyname_r='undef'
d_getprotobynumber_r='undef'
d_getprotoent_r='undef'
d_getprotoprotos='define'
d_getprpwnam='undef'
d_getpwent='define'
d_getpwent_r='undef'
d_getpwnam_r='undef'
d_getpwuid_r='undef'
d_getsbyaddr='undef'
d_getsbyname='define'
d_getsbyport='define'
d_getsent='define'
d_getservbyname_r='undef'
d_getservbyport_r='undef'
d_getservent_r='undef'
d_getservprotos='define'
d_getspnam='define'
d_getspnam_r='undef'
d_gettimeod='define'
d_gmtime64='undef'
d_gmtime_r='undef'
d_gnulibc='define'
d_grpasswd='define'
d_hasmntopt='define'
d_htonl='define'
d_hypot='define'
d_ilogb='define'
d_ilogbl='define'
d_inc_version_list='undef'
d_index='define'
d_inetaton='define'
d_inetntop='define'
d_inetpton='define'
d_int64_t='define'
d_ip_mreq='define'
d_ip_mreq_source='define'
d_ipv6_mreq='define'
d_ipv6_mreq_source='undef'
d_isascii='define'
d_isblank='define'
d_isfinite='define'
d_isfinitel='undef'
d_isinf='define'
d_isinfl='define'
d_isless='define'
d_isnan='define'
d_isnanl='define'
d_isnormal='define'
d_j0='define'
d_j0l='define'
d_killpg='define'
d_lc_monetary_2008='undef'
d_lchown='define'
d_ldbl_dig='define'
d_ldexpl='define'
d_lgamma='define'
d_lgamma_r='define'
d_libm_lib_version='undef'
d_libname_unique='undef'
d_link='define'
d_linkat='define'
d_llabs='define'
d_llrint='define'
d_llrintl='define'
d_llround='define'
d_llroundl='define'
d_localeconv_l='undef'
d_localtime64='undef'
d_localtime_r='undef'
d_localtime_r_needs_tzset='define'
d_locconv='define'
d_lockf='define'
d_log1p='define'
d_log2='define'
d_logb='define'
d_long_double_style_ieee='undef'
d_long_double_style_ieee_doubledouble='undef'
d_long_double_style_ieee_extended='undef'
d_long_double_style_ieee_std='undef'
d_long_double_style_vax='undef'
d_longdbl='define'
d_longlong='define'
d_lrint='define'
d_lrintl='define'
d_lround='define'
d_lroundl='define'
d_lseekproto='define'
d_lstat='define'
d_madvise='define'
d_malloc_good_size='undef'
d_malloc_size='undef'
d_mblen='define'
d_mbrlen='define'
d_mbrtowc='define'
d_mbstowcs='define'
d_mbtowc='define'
d_memchr='define'
d_memcmp='define'
d_memcpy='define'
d_memmem='define'
d_memmove='define'
d_memrchr='define'
d_memset='define'
d_mkdir='define'
d_mkdtemp='define'
d_mkfifo='define'
d_mkostemp='define'
d_mkstemp='define'
d_mkstemps='define'
d_mktime='define'
d_mktime64='undef'
d_mmap='define'
d_modfl='define'
d_modfl_pow32_bug='undef'
d_modflproto='define'
d_mprotect='define'
d_msg='define'
d_msg_ctrunc='undef'
d_msg_dontroute='undef'
d_msg_oob='undef'
d_msg_peek='undef'
d_msg_proxy='undef'
d_msgctl='define'
d_msgget='define'
d_msghdr_s='define'
d_msgrcv='define'
d_msgsnd='define'
d_msync='define'
d_munmap='define'
d_mymalloc='undef'
d_nan='define'
d_nanosleep='define'
d_ndbm='undef'
d_ndbm_h_uses_prototypes='define'
d_nearbyint='define'
d_newlocale='define'
d_nextafter='define'
d_nexttoward='define'
d_nice='define'
d_nl_langinfo='define'
d_nl_langinfo_l='define'
d_nv_preserves_uv='undef'
d_nv_zero_is_allbits_zero='define'
d_off64_t='define'
d_old_pthread_create_joinable='undef'
d_oldpthreads='undef'
d_oldsock='undef'
d_open='define'
d_open3='define'
d_openat='define'
d_pathconf='define'
d_pause='define'
d_perl_otherlibdirs='undef'
d_phostname='undef'
d_pipe='define'
d_pipe2='undef'
d_poll='define'
d_portable='define'
d_prctl='define'
d_prctl_set_name='define'
d_printf_format_null='define'
d_procselfexe='define'
d_pseudofork='undef'
d_pthread_atfork='define'
d_pthread_attr_setscope='define'
d_pthread_yield='undef'
d_ptrdiff_t='define'
d_pwage='undef'
d_pwchange='undef'
d_pwclass='undef'
d_pwcomment='undef'
d_pwexpire='undef'
d_pwgecos='define'
d_pwpasswd='define'
d_pwquota='undef'
d_qgcvt='define'
d_quad='define'
d_querylocale='undef'
d_rand='define'
d_random='define'
d_random_r='undef'
d_re_comp='define'
d_readdir='define'
d_readdir64_r='undef'
d_readdir_r='undef'
d_readlink='define'
d_readv='define'
d_realpath='define'
d_recvmsg='define'
d_regcmp='undef'
d_regcomp='define'
d_remainder='define'
d_remquo='define'
d_rename='define'
d_renameat='define'
d_rewinddir='define'
d_rint='define'
d_rmdir='define'
d_round='define'
d_safebcpy='define'
d_safemcpy='undef'
d_sanemcmp='define'
d_sbrkproto='define'
d_scalbn='define'
d_scalbnl='define'
d_sched_yield='define'
d_scm_rights='define'
d_seekdir='define'
d_select='define'
d_sem='define'
d_semctl='define'
d_semctl_semid_ds='define'
d_semctl_semun='define'
d_semget='define'
d_semop='define'
d_sendmsg='define'
d_setegid='define'
d_setent='define'
d_setenv='define'
d_seteuid='define'
d_setgrent='define'
d_setgrent_r='undef'
d_setgrps='define'
d_sethent='define'
d_sethostent_r='undef'
d_setitimer='define'
d_setlinebuf='define'
d_setlocale='define'
d_setlocale_accepts_any_locale_name='undef'
d_setlocale_r='undef'
d_setnent='define'
d_setnetent_r='undef'
d_setpent='define'
d_setpgid='define'
d_setpgrp='define'
d_setpgrp2='undef'
d_setprior='define'
d_setproctitle='undef'
d_setprotoent_r='undef'
d_setpwent='define'
d_setpwent_r='undef'
d_setregid='define'
d_setresgid='define'
d_setresuid='define'
d_setreuid='define'
d_setrgid='undef'
d_setruid='undef'
d_setsent='define'
d_setservent_r='undef'
d_setsid='define'
d_setvbuf='define'
d_sfreserve='undef'
d_shm='define'
d_shmat='define'
d_shmatprototype='define'
d_shmctl='define'
d_shmdt='define'
d_shmget='define'
d_sigaction='define'
d_siginfo_si_addr='define'
d_siginfo_si_band='define'
d_siginfo_si_errno='define'
d_siginfo_si_fd='define'
d_siginfo_si_pid='define'
d_siginfo_si_status='define'
d_siginfo_si_uid='define'
d_siginfo_si_value='define'
d_signbit='define'
d_sigprocmask='define'
d_sigsetjmp='define'
d_sin6_scope_id='define'
d_sitearch='define'
d_snprintf='define'
d_sockaddr_in6='define'
d_sockaddr_sa_len='undef'
d_sockaddr_storage='define'
d_sockatmark='define'
d_sockatmarkproto='define'
d_socket='define'
d_socklen_t='define'
d_sockpair='define'
d_socks5_init='undef'
d_sprintf_returns_strlen='define'
d_sqrtl='define'
d_srand48_r='undef'
d_srandom_r='undef'
d_sresgproto='define'
d_sresuproto='define'
d_stat='define'
d_statblks='define'
d_statfs_f_flags='define'
d_statfs_s='define'
d_static_inline='undef'
d_statvfs='define'
d_stdio_cnt_lval='undef'
d_stdio_ptr_lval='undef'
d_stdio_ptr_lval_nochange_cnt='undef'
d_stdio_ptr_lval_sets_cnt='undef'
d_stdio_stream_array='undef'
d_stdiobase='undef'
d_stdstdio='undef'
d_strchr='define'
d_strcoll='define'
d_strctcpy='define'
d_strerrm='strerror(e)'
d_strerror='define'
d_strerror_l='define'
d_strerror_r='undef'
d_strftime='define'
d_strlcat='define'
d_strlcpy='define'
d_strnlen='define'
d_strtod='define'
d_strtod_l='define'
d_strtol='define'
d_strtold='define'
d_strtold_l='define'
d_strtoll='define'
d_strtoq='define'
d_strtoul='define'
d_strtoull='define'
d_strtouq='define'
d_strxfrm='define'
d_suidsafe='undef'
d_symlink='define'
d_syscall='define'
d_syscallproto='define'
d_sysconf='define'
d_sysernlst='undef'
d_syserrlst='undef'
d_system='define'
d_tcgetpgrp='define'
d_tcsetpgrp='define'
d_telldir='define'
d_telldirproto='define'
d_tgamma='define'
d_thread_safe_nl_langinfo_l='define'
d_time='define'
d_timegm='define'
d_times='define'
d_tm_tm_gmtoff='define'
d_tm_tm_zone='define'
d_tmpnam_r='undef'
d_towlower='define'
d_towupper='define'
d_trunc='define'
d_truncate='define'
d_truncl='define'
d_ttyname_r='undef'
d_tzname='define'
d_u32align='undef'
d_ualarm='define'
d_umask='define'
d_uname='define'
d_union_semun='undef'
d_unlinkat='define'
d_unordered='undef'
d_unsetenv='define'
d_uselocale='define'
d_usleep='define'
d_usleepproto='define'
d_ustat='undef'
d_vendorarch='undef'
d_vendorbin='undef'
d_vendorlib='undef'
d_vendorscript='undef'
d_vfork='undef'
d_vms_case_sensitive_symbols='undef'
d_void_closedir='undef'
d_voidsig='define'
d_voidtty='define'
d_volatile='define'
d_vprintf='define'
d_vsnprintf='define'
d_wait4='define'
d_waitpid='define'
d_wcrtomb='define'
d_wcscmp='define'
d_wcstombs='define'
d_wcsxfrm='define'
d_wctomb='define'
d_writev='define'
d_xenix='undef'
date='date'
db_hashtype='unsigned int'
db_prefixtype='size_t'
db_version_major=''
db_version_minor=''
db_version_patch=''
default_inc_excludes_dot='define'
direntrytype='struct dirent'
disabled_dynamic_ext='ext/Amiga-ARexx ext/Amiga-Exec ext/GDBM_File ext/NDBM_File ext/ODBM_File ext/VMS-DCLsym ext/VMS-Stdio ext/Win32CORE cpan/DB_File cpan/Win32 cpan/Win32API-File'
disabled_nonxs_ext='ext/VMS-Filespec'
dl_so_eq_ext='define'
dlext='so'
dlsrc='dl_dlopen.xs'
doubleinfbytes='0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x7f'
doublekind='3'
doublemantbits='52'
doublenanbytes='0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x7f'
doublesize='8'
drand01='drand48()'
drand48_r_proto='0'
dtrace=''
dynamic_ext='B Devel/Peek Fcntl File/DosGlob File/Glob Hash/Util Hash/Util/FieldHash I18N/Langinfo Opcode POSIX PerlIO/encoding PerlIO/mmap PerlIO/scalar PerlIO/via SDBM_File Sys/Hostname XS/APItest XS/Typemap attributes mro re Compress/Raw/Bzip2 Compress/Raw/Zlib Digest/MD5 Digest/SHA Encode Filter/Util/Call IPC/SysV MIME/Base64 Math/BigInt/FastCalc Scalar/List/Utils Socket Sys/Syslog Time/Piece Unicode/Collate Data/Dumper Devel/PPPort IO PathTools Storable Time/HiRes Unicode/Normalize threads threads/shared'
eagain='EAGAIN'
ebcdic='undef'
echo='echo'
egrep='egrep'
emacs=''
endgrent_r_proto='0'
endhostent_r_proto='0'
endnetent_r_proto='0'
endprotoent_r_proto='0'
endpwent_r_proto='0'
endservent_r_proto='0'
eunicefix=':'
exe_ext=''
expr='expr'
extensions='B Devel/Peek Errno ExtUtils/Miniperl Fcntl File/DosGlob File/Find File/Glob FileCache Hash/Util Hash/Util/FieldHash I18N/Langinfo IPC/Open3 Opcode POSIX PerlIO/encoding PerlIO/mmap PerlIO/scalar PerlIO/via Pod/Functions Pod/Html SDBM_File Sys/Hostname Tie/Hash/NamedCapture Tie/Memoize XS/APItest XS/Typemap attributes mro re Archive/Tar AutoLoader CPAN CPAN/Meta CPAN/Meta/Requirements CPAN/Meta/YAML Compress/Raw/Bzip2 Compress/Raw/Zlib Config/Perl/V Digest Digest/MD5 Digest/SHA Encode ExtUtils/Constant ExtUtils/Install ExtUtils/MakeMaker ExtUtils/Manifest File/Fetch File/Path File/Temp Filter/Util/Call Getopt/Long HTTP/Tiny IO/Compress IO/Socket/IP IO/Zlib IPC/Cmd IPC/SysV JSON/PP Locale/Maketext/Simple MIME/Base64 Math/BigInt Math/BigInt/FastCalc Math/BigRat Math/Complex Memoize Module/Load Module/Load/Conditional Module/Loaded Module/Metadata NEXT Params/Check Perl/OSType PerlIO/via/QuotedPrint Pod/Checker Pod/Escapes Pod/Perldoc Pod/Simple Pod/Usage Scalar/List/Utils Socket Sys/Syslog Term/ANSIColor Term/Cap Test/Harness Test/Simple Text/Balanced Text/ParseWords Text/Tabs Tie/RefHash Time/Local Time/Piece Unicode/Collate autodie bignum experimental libnet parent perlfaq podlators version Attribute/Handlers Carp Data/Dumper Devel/PPPort Devel/SelfStubber Dumpvalue Env Exporter ExtUtils/CBuilder ExtUtils/ParseXS Filter/Simple FindBin I18N/Collate I18N/LangTags IO Locale/Maketext Module/CoreList Net/Ping PathTools Safe Search/Dict SelfLoader Storable Term/Complete Term/ReadLine Test Text/Abbrev Thread/Queue Thread/Semaphore Tie/File Time/HiRes Unicode/Normalize XSLoader autouse base constant encoding/warnings if lib threads threads/shared'
extern_C='extern'
extras=''
fflushNULL='define'
fflushall='undef'
find=''
firstmakefile='Makefile'
flex=''
fpossize='16'
fpostype='fpos_t'
freetype='void'
from=':'
full_ar='ar'
full_csh='csh'
full_sed='sed'
fullpath_dynamic_ext='ext/B ext/Devel-Peek ext/Fcntl ext/File-DosGlob ext/File-Glob ext/Hash-Util ext/Hash-Util-FieldHash ext/I18N-Langinfo ext/Opcode ext/POSIX ext/PerlIO-encoding ext/PerlIO-mmap ext/PerlIO-scalar ext/PerlIO-via ext/SDBM_File ext/Sys-Hostname ext/XS-APItest ext/XS-Typemap ext/attributes ext/mro ext/re cpan/Compress-Raw-Bzip2 cpan/Compress-Raw-Zlib cpan/Digest-MD5 cpan/Digest-SHA cpan/Encode cpan/Filter-Util-Call cpan/IPC-SysV cpan/MIME-Base64 cpan/Math-BigInt-FastCalc cpan/Scalar-List-Utils cpan/Socket cpan/Sys-Syslog cpan/Time-Piece cpan/Unicode-Collate dist/Data-Dumper dist/Devel-PPPort dist/IO dist/PathTools dist/Storable dist/Time-HiRes dist/Unicode-Normalize dist/threads dist/threads-shared'
fullpath_nonxs_ext='ext/Errno ext/ExtUtils-Miniperl ext/File-Find ext/FileCache ext/IPC-Open3 ext/Pod-Functions ext/Pod-Html ext/Tie-Hash-NamedCapture ext/Tie-Memoize cpan/Archive-Tar cpan/AutoLoader cpan/CPAN cpan/CPAN-Meta cpan/CPAN-Meta-Requirements cpan/CPAN-Meta-YAML cpan/Config-Perl-V cpan/Digest cpan/ExtUtils-Constant cpan/ExtUtils-Install cpan/ExtUtils-MakeMaker cpan/ExtUtils-Manifest cpan/File-Fetch cpan/File-Path cpan/File-Temp cpan/Getopt-Long cpan/HTTP-Tiny cpan/IO-Compress cpan/IO-Socket-IP cpan/IO-Zlib cpan/IPC-Cmd cpan/JSON-PP cpan/Locale-Maketext-Simple cpan/Math-BigInt cpan/Math-BigRat cpan/Math-Complex cpan/Memoize cpan/Module-Load cpan/Module-Load-Conditional cpan/Module-Loaded cpan/Module-Metadata cpan/NEXT cpan/Params-Check cpan/Perl-OSType cpan/PerlIO-via-QuotedPrint cpan/Pod-Checker cpan/Pod-Escapes cpan/Pod-Perldoc cpan/Pod-Simple cpan/Pod-Usage cpan/Term-ANSIColor cpan/Term-Cap cpan/Test-Harness cpan/Test-Simple cpan/Text-Balanced cpan/Text-ParseWords cpan/Text-Tabs cpan/Tie-RefHash cpan/Time-Local cpan/autodie cpan/bignum cpan/experimental cpan/libnet cpan/parent cpan/perlfaq cpan/podlators cpan/version dist/Attribute-Handlers dist/Carp dist/Devel-SelfStubber dist/Dumpvalue dist/Env dist/Exporter dist/ExtUtils-CBuilder dist/ExtUtils-ParseXS dist/Filter-Simple dist/FindBin dist/I18N-Collate dist/I18N-LangTags dist/Locale-Maketext dist/Module-CoreList dist/Net-Ping dist/Safe dist/Search-Dict dist/SelfLoader dist/Term-Complete dist/Term-ReadLine dist/Test dist/Text-Abbrev dist/Thread-Queue dist/Thread-Semaphore dist/Tie-File dist/XSLoader dist/autouse dist/base dist/constant dist/encoding-warnings dist/if dist/lib'
fullpath_static_ext=''
gccansipedantic=''
gccosandvers=''
gccversion='12.3.0'
getcwdnull='define'
getgrent_r_proto='0'
getgrgid_r_proto='0'
getgrnam_r_proto='0'
gethostbyaddr_r_proto='0'
gethostbyname_r_proto='0'
gethostent_r_proto='0'
getlogin_r_proto='0'
getnetbyaddr_r_proto='0'
getnetbyname_r_proto='0'
getnetent_r_proto='0'
getprotobyname_r_proto='0'
getprotobynumber_r_proto='0'
getprotoent_r_proto='0'
getpwent_r_proto='0'
getpwnam_r_proto='0'
getpwuid_r_proto='0'
getservbyname_r_proto='0'
getservbyport_r_proto='0'
getservent_r_proto='0'
getspnam_r_proto='0'
gidformat='"lu"'
gidsign='1'
gidsize='4'
gidtype='gid_t'
glibpth='/lib /usr/lib /usr/local/lib'
gmake='gmake'
gmtime_r_proto='0'
gnulibc_version=''
grep='grep'
groupcat='cat /etc/group'
groupstype='gid_t'
gzip='gzip'
h_fcntl='false'
h_sysfile='true'
hash_func='FNV1A'
hint='default'
hostcat='cat /etc/hosts'
html1dir='/usr/share/doc/perl/html'
html1direxp='/usr/share/doc/perl/html'
html3dir='/usr/share/doc/perl/html'
html3direxp='/usr/share/doc/perl/html'
i16size='2'
i16type='int16_t'
i32size='4'
i32type='int32_t'
i64size='8'
i64type='int64_t'
i8size='1'
i8type='int8_t'
i_arpainet='define'
i_assert='define'
i_bfd='undef'
i_bsdioctl='undef'
i_crypt='define'
i_db='undef'
i_dbm='undef'
i_dirent='define'
i_dlfcn='define'
i_execinfo='define'
i_fcntl='define'
i_fenv='define'
i_float='define'
i_fp='undef'
i_fp_class='undef'
i_gdbm='undef'
i_gdbm_ndbm='undef'
i_gdbmndbm='undef'
i_grp='define'
i_ieeefp='undef'
i_inttypes='define'
i_langinfo='define'
i_libutil='undef'
i_limits='define'
i_locale='define'
i_machcthr='undef'
i_malloc='define'
i_mallocmalloc='undef'
i_math='define'
i_memory='define'
i_mntent='define'
i_ndbm='undef'
i_netdb='define'
i_neterrno='undef'
i_netinet6_in6='undef'
i_netinet_in_systm='define'
i_netinet_ip='define'
i_netinet_ip6='define'
i_netinettcp='define'
i_niin='define'
i_poll='define'
i_prot='undef'
i_pthread='define'
i_pwd='define'
i_quadmath='undef'
i_rpcsvcdbm='undef'
i_sgtty='define'
i_shadow='define'
i_socks='undef'
i_stdarg='define'
i_stdbool='define'
i_stddef='define'
i_stdint='define'
i_stdlib='define'
i_string='define'
i_sunmath='undef'
i_sysaccess='undef'
i_sysdir='define'
i_sysfile='define'
i_sysfilio='undef'
i_sysin='undef'
i_sysioctl='define'
i_syslog='define'
i_sysmman='define'
i_sysmode='undef'
i_sysmount='define'
i_sysndir='undef'
i_sysparam='define'
i_syspoll='define'
i_sysresrc='define'
i_syssecrt='undef'
i_sysselct='define'
i_syssockio='undef'
i_sysstat='define'
i_sysstatfs='define'
i_sysstatvfs='define'
i_systime='define'
i_systimek='undef'
i_systimes='define'
i_systypes='define'
i_sysuio='define'
i_sysun='define'
i_sysutsname='define'
i_sysvfs='define'
i_syswait='define'
i_termio='define'
i_termios='define'
i_time='define'
i_unistd='define'
i_ustat='undef'
i_utime='define'
i_valgrind='undef'
i_values='define'
i_varargs='undef'
i_varhdr='stdarg.h'
i_vfork='undef'
i_wchar='define'
i_wctype='define'
i_xlocale='undef'
i_zlib='define'
ignore_versioned_solibs=''
inc_version_list=''
inc_version_list_init=''
incpath=''
inews=''
initialinstalllocation=''
installarchlib='/usr/lib/perl5/5.32.1/aarch64-linux'
installbin='/usr/bin'
installhtml1dir='/usr/share/doc/perl/html'
installhtml3dir='/usr/share/doc/perl/html'
installlib='/usr/lib'
installman1dir='/usr/share/man/man1'
installman3dir='/usr/share/man/man3'
installprefix=''
installprefixexp=''
installprivlib='/usr/lib/perl5/5.32.1'
installscript='/usr/bin'
installsitearch='/usr/lib/perl5/site_perl/5.32.1/aarch64-linux'
installsitebin='/usr/bin'
installsitehtml1dir='/usr/share/doc/perl/html'
installsitehtml3dir='/usr/share/doc/perl/html'
installsitelib='/usr/lib/perl5/site_perl/5.32.1'
installsiteman1dir='/usr/share/man/man1'
installsiteman3dir='/usr/share/man/man3'
installsitescript='/usr/bin'
installstyle='lib/perl5'
installusrbinperl='define'
installvendorarch=''
installvendorbin=''
installvendorhtml1dir=''
installvendorhtml3dir=''
installvendorlib=''
installvendorman1dir=''
installvendorman3dir=''
installvendorscript=''
intsize='4'
issymlink='test -h'
ivdformat='"ld"'
ivsize='8'
ivtype='long'
keeplog='1'
known_extensions='Amiga/ARexx Amiga/Exec B Devel/Peek Errno ExtUtils/Miniperl Fcntl File/DosGlob File/Find File/Glob FileCache GDBM_File Hash/Util Hash/Util/FieldHash I18N/Langinfo IPC/Open3 NDBM_File ODBM_File Opcode POSIX PerlIO/encoding PerlIO/mmap PerlIO/scalar PerlIO/via Pod/Functions Pod/Html SDBM_File Sys/Hostname Tie/Hash/NamedCapture Tie/Memoize VMS/DCLsym VMS/Filespec VMS/Stdio Win32CORE XS/APItest XS/Typemap attributes mro re Archive/Tar AutoLoader CPAN CPAN/Meta CPAN/Meta/Requirements CPAN/Meta/YAML Compress/Raw/Bzip2 Compress/Raw/Zlib Config/Perl/V DB_File Digest Digest/MD5 Digest/SHA Encode ExtUtils/Constant ExtUtils/Install ExtUtils/MakeMaker ExtUtils/Manifest File/Fetch File/Path File/Temp Filter/Util/Call Getopt/Long HTTP/Tiny IO/Compress IO/Socket/IP IO/Zlib IPC/Cmd IPC/SysV JSON/PP Locale/Maketext/Simple MIME/Base64 Math/BigInt Math/BigInt/FastCalc Math/BigRat Math/Complex Memoize Module/Load Module/Load/Conditional Module/Loaded Module/Metadata NEXT Params/Check Perl/OSType PerlIO/via/QuotedPrint Pod/Checker Pod/Escapes Pod/Perldoc Pod/Simple Pod/Usage Scalar/List/Utils Socket Sys/Syslog Term/ANSIColor Term/Cap Test/Harness Test/Simple Text/Balanced Text/ParseWords Text/Tabs Tie/RefHash Time/Local Time/Piece Unicode/Collate Win32 Win32API/File autodie bignum experimental libnet parent perlfaq podlators version Attribute/Handlers Carp Data/Dumper Devel/PPPort Devel/SelfStubber Dumpvalue Env Exporter ExtUtils/CBuilder ExtUtils/ParseXS Filter/Simple FindBin I18N/Collate I18N/LangTags IO Locale/Maketext Module/CoreList Net/Ping PathTools Safe Search/Dict SelfLoader Storable Term/Complete Term/ReadLine Test Text/Abbrev Thread/Queue Thread/Semaphore Tie/File Time/HiRes Unicode/Normalize XSLoader autouse base constant encoding/warnings if lib threads threads/shared'
ksh=''
ld='/home/ych/rk3568/buildroot/output/rockchip_rk3568/host/bin/aarch64-buildroot-linux-gnu-gcc'
ld_can_script='define'
lddlflags='-shared'
ldflags=' -lm '
ldflags_uselargefiles=''
ldlibpthname='LD_LIBRARY_PATH'
less='less'
lib='/usr/lib'
lib_ext='.a'
libc=''
libperl='libperl.a'
libpth='/lib /usr/lib /usr/local/lib'
libs='-lm -lcrypt -lpthread -ldbm -ldl'
libs_uselargefiles=''
libsdirs=' '
libsfiles=''
libsfound=''
libspath=''
libswanted='m crypt pthread nm ndbm gdbm dbm db dl gdbm_compat'
libswanted_uselargefiles=''
line=''
lint=''
lkflags=''
ln='ln'
lns='ln -s'
localtime_r_proto='0'
locincpth=''
loclibpth=''
longdblinfbytes='0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x7f'
longdblkind='0'
longdblmantbits='112'
longdblnanbytes='0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x7f'
longdblsize='16'
longlongsize='8'
longsize='8'
lp=''
lpr=''
ls='ls'
lseeksize='8'
lseektype='off_t'
mail=''
mailx=''
make='make'
make_set_make='#'
mallocobj=''
mallocsrc=''
malloctype='void*'
man1dir='/usr/share/man/man1'
man1direxp='/usr/share/man/man1'
man1ext='1'
man3dir='/usr/share/man/man3'
man3direxp='/usr/share/man/man3'
man3ext='3'
mips_type=''
mistrustnm=''
mkdir='mkdir'
mmaptype='void *'
modetype='mode_t'
more='more'
multiarch='undef'
mv=''
myarchname=''
mydomain=''
myhostname='noname'
myuname='Buildroot linux-5.10-gen-rkr8'
n=''
need_va_copy='define'
netdb_hlen_type='socklen_t'
netdb_host_type='const void *'
netdb_name_type='int'
netdb_net_type='uint32_t'
nm='/home/ych/rk3568/buildroot/output/rockchip_rk3568/host/bin/aarch64-buildroot-linux-gnu-nm'
nm_opt=''
nm_so_opt=''
nonxs_ext='Errno ExtUtils/Miniperl File/Find FileCache IPC/Open3 Pod/Functions Pod/Html Tie/Hash/NamedCapture Tie/Memoize Archive/Tar AutoLoader CPAN CPAN/Meta CPAN/Meta/Requirements CPAN/Meta/YAML Config/Perl/V Digest ExtUtils/Constant ExtUtils/Install ExtUtils/MakeMaker ExtUtils/Manifest File/Fetch File/Path File/Temp Getopt/Long HTTP/Tiny IO/Compress IO/Socket/IP IO/Zlib IPC/Cmd JSON/PP Locale/Maketext/Simple Math/BigInt Math/BigRat Math/Complex Memoize Module/Load Module/Load/Conditional Module/Loaded Module/Metadata NEXT Params/Check Perl/OSType PerlIO/via/QuotedPrint Pod/Checker Pod/Escapes Pod/Perldoc Pod/Simple Pod/Usage Term/ANSIColor Term/Cap Test/Harness Test/Simple Text/Balanced Text/ParseWords Text/Tabs Tie/RefHash Time/Local autodie bignum experimental libnet parent perlfaq podlators version Attribute/Handlers Carp Devel/SelfStubber Dumpvalue Env Exporter ExtUtils/CBuilder ExtUtils/ParseXS Filter/Simple FindBin I18N/Collate I18N/LangTags Locale/Maketext Module/CoreList Net/Ping Safe Search/Dict SelfLoader Term/Complete Term/ReadLine Test Text/Abbrev Thread/Queue Thread/Semaphore Tie/File XSLoader autouse base constant encoding/warnings if lib'
nroff='nroff'
nvEUformat='"E"'
nvFUformat='"F"'
nvGUformat='"G"'
nv_overflows_integers_at='256.0*256.0*256.0*256.0*256.0*256.0*2.0*2.0*2.0*2.0*2.0'
nv_preserves_uv_bits='53'
nveformat='"e"'
nvfformat='"f"'
nvgformat='"g"'
nvmantbits='52'
nvsize='8'
nvtype='double'
o_nonblock='O_NONBLOCK'
obj_ext='.o'
objdump='/home/ych/rk3568/buildroot/output/rockchip_rk3568/host/bin/aarch64-buildroot-linux-gnu-objdump'
old_pthread_create_joinable='PTHREAD_CREATE_JOINABLE'
optimize='-fwrapv -fno-strict-aliasing'
orderlib=''
osname='linux'
osvers='custom'
otherlibdirs=''
package='perl5'
pager='less'
passcat='cat /etc/passwd'
patchlevel='32'
path_sep=':'
perl=''
perl5=''
perl_patchlevel=''
perl_static_inline='static'
perladmin='root'
perllibs='-lm -lcrypt -ldl'
perlname='perl'
perlpath='/usr/bin/perl'
pg='pg'
phostname='hostname'
pidtype='pid_t'
plibpth=''
pmake=''
pr=''
prefix='/usr'
prefixexp='/usr'
privlib='/usr/lib/perl5/5.32.1'
privlibexp='/usr/lib/perl5/5.32.1'
procselfexe='"/proc/self/exe"'
prototype='define'
ptrsize='8'
quadkind='QUAD_IS_INT64_t'
quadtype='int64_t'
randbits='48'
randfunc='drand48'
random_r_proto='0'
randseedtype='long'
ranlib='/home/ych/rk3568/buildroot/output/rockchip_rk3568/host/bin/aarch64-buildroot-linux-gnu-ranlib'
rd_nodata='-1'
readdir64_r_proto='0'
readdir_r_proto='0'
readelf='/home/ych/rk3568/buildroot/output/rockchip_rk3568/host/bin/aarch64-buildroot-linux-gnu-readelf'
revision='5'
rm='rm'
rm_try=''
rmail=''
run='false'
runnm='false'
sGMTIME_max='2147483647'
sGMTIME_min='-2147483648'
sLOCALTIME_max='2147483647'
sLOCALTIME_min='-2147483648'
sPRIEUldbl='"LE"'
sPRIFUldbl='"LF"'
sPRIGUldbl='"LG"'
sPRIXU64='"LX"'
sPRId64='"Ld"'
sPRIeldbl='"Le"'
sPRIfldbl='"Lf"'
sPRIgldbl='"Lg"'
sPRIi64='"Li"'
sPRIo64='"Lo"'
sPRIu64='"Lu"'
sPRIx64='"Lx"'
sSCNfldbl='"Lf"'
sanitize_address='undef'
sched_yield='sched_yield()'
scriptdir='/usr/bin'
scriptdirexp='/usr/bin'
sed='sed'
seedfunc='srand48'
selectminbits='32'
selecttype='fd_set *'
sendmail=''
setgrent_r_proto='0'
sethostent_r_proto='0'
setlocale_r_proto='0'
setnetent_r_proto='0'
setprotoent_r_proto='0'
setpwent_r_proto='0'
setservent_r_proto='0'
sh='/bin/sh'
shar=''
sharedir='/usr/share'
sharpbang='#!'
shmattype='void *'
shortsize='2'
shrpenv=''
shsharp='true'
sig_count='641'
sig_name='ZERO HUP INT QUIT ILL TRAP ABRT BUS FPE KILL USR1 SEGV USR2 PIPE ALRM TERM STKFLT CHLD CONT STOP TSTP TTIN TTOU URG XCPU XFSZ VTALRM PROF WINCH IO PWR SYS IOT CLD POLL'
sig_name_init='"ZERO", "HUP", "INT", "QUIT", "ILL", "TRAP", "ABRT", "BUS", "FPE", "KILL", "USR1", "SEGV", "USR2", "PIPE", "ALRM", "TERM", "STKFLT", "CHLD", "CONT", "STOP", "TSTP", "TTIN", "TTOU", "URG", "XCPU", "XFSZ", "VTALRM", "PROF", "WINCH", "IO", "PWR", "SYS", "IOT", "CLD", "POLL", 0'
sig_num='0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 6 17 29'
sig_num_init='0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 6, 17, 29, 0'
sig_size='35'
signal_t='void'
sitearch='/usr/lib/perl5/site_perl/5.32.1/aarch64-linux'
sitearchexp='/usr/lib/perl5/site_perl/5.32.1/aarch64-linux'
sitebin='/usr/bin'
sitebinexp='/usr/bin'
sitehtml1dir='/usr/share/doc/perl/html'
sitehtml1direxp='/usr/share/doc/perl/html'
sitehtml3dir='/usr/share/doc/perl/html'
sitehtml3direxp='/usr/share/doc/perl/html'
sitelib='/usr/lib/perl5/site_perl/5.32.1'
sitelib_stem='/usr/lib/perl5/site_perl'
sitelibexp='/usr/lib/perl5/site_perl/5.32.1'
siteman1dir='/usr/share/man/man1'
siteman1direxp='/usr/share/man/man1'
siteman3dir='/usr/share/man/man3'
siteman3direxp='/usr/share/man/man3'
siteprefix='/usr'
siteprefixexp='/usr'
sitescript='/usr/bin'
sitescriptexp='/usr/bin'
sizesize='8'
sizetype='size_t'
sleep=''
smail=''
so='so'
sockethdr=''
socketlib=''
socksizetype='socklen_t'
sort='sort'
spackage='Perl5'
spitshell='cat'
srand48_r_proto='0'
srandom_r_proto='0'
src=''
ssizetype='ssize_t'
st_ino_sign='1'
st_ino_size='8'
startperl='#!/usr/bin/perl'
startsh='#!/bin/sh'
static_ext=''
stdchar='char'
stdio_base=''
stdio_bufsiz=''
stdio_cnt=''
stdio_filbuf=''
stdio_ptr=''
stdio_stream_array=''
strerror_r_proto='0'
strings=''
submit=''
subversion='1'
sysincpth=''
syslibpth=''
sysman=''
tail=''
tar=''
target='aarch64-buildroot-linux-gnu'
targetarch='aarch64-buildroot-linux-gnu'
targetsh='/bin/sh'
tbl=''
tee=''
test='test'
timeincl=''
timesize='8'
timetype='time_t'
tmpnam_r_proto='0'
to=':'
touch='touch'
tr='tr'
trnl='tr'
troff=''
ttyname_r_proto='0'
u16size='2'
u16type='uint16_t'
u32size='4'
u32type='uint32_t'
u64size='8'
u64type='uint64_t'
u8size='1'
u8type='uint8_t'
uidformat='"lu"'
uidsign='1'
uidsize='4'
uidtype='uid_t'
uname='uname'
uniq='uniq'
uquadtype='uint64_t'
use5005threads='undef'
use64bitall='undef'
use64bitint='undef'
usecbacktrace='undef'
usecrosscompile='define'
usedefaultstrict='undef'
usedevel='undef'
usedl='define'
usedtrace='undef'
usefaststdio='undef'
useffi='undef'
useithreads='undef'
usekernprocpathname='undef'
uselargefiles='define'
uselongdouble='undef'
usemallocwrap='define'
usemmldlt='define'
usemorebits='undef'
usemultiplicity='undef'
usemymalloc='n'
usenamedanoncv='undef'
usenm='false'
usensgetexecutablepath='undef'
useopcode='true'
useperlio='define'
useposix='true'
usequadmath='undef'
usereentrant='undef'
userelocatableinc='undef'
usesafehashiter='undef'
usesfio='false'
useshrplib='false'
usesitecustomize='undef'
usesocks='undef'
usethreads='undef'
usevendorprefix='undef'
useversionedarchname='undef'
usevfork='false'
usrinc=''
uuname=''
uvXUformat='"lX"'
uvoformat='"lo"'
uvsize='8'
uvtype='unsigned long'
uvuformat='"lu"'
uvxformat='"lx"'
vaproto='define'
vendorarch=''
vendorarchexp=''
vendorbin=''
vendorbinexp=''
vendorhtml1dir=''
vendorhtml1direxp=''
vendorhtml3dir=''
vendorhtml3direxp=''
vendorlib=''
vendorlib_stem=''
vendorlibexp=''
vendorman1dir=''
vendorman1direxp=''
vendorman3dir=''
vendorman3direxp=''
vendorprefix=''
vendorprefixexp=''
vendorscript=''
vendorscriptexp=''
version='5.32.1'
version_patchlevel_string='version 32 subversion 1'
versiononly='undef'
vi=''
xlibpth=''
yacc='yacc'
yaccflags=''
zcat=''
zip='zip'
!END!

my $i = ord(8);
foreach my $c (7,6,5,4,3,2,1) { $i <<= 8; $i |= ord($c); }
our $byteorder = join('', unpack('aaaaaaaa', pack('L!', $i)));
s/(byteorder=)(['"]).*?\2/$1$2$Config::byteorder$2/m;

my $config_sh_len = length $_;

our $Config_SH_expanded = "\n$_" . << 'EOVIRTUAL';
ccflags_nolargefiles='-D_LARGEFILE_SOURCE -D_LARGEFILE64_SOURCE -D_FILE_OFFSET_BITS=64  -Os -g0 -D_FORTIFY_SOURCE=1'
ldflags_nolargefiles=' -lm '
libs_nolargefiles='-lm -lcrypt -lpthread -ldbm -ldl'
libswanted_nolargefiles='m crypt pthread nm ndbm gdbm dbm db dl gdbm_compat'
ccwarnflags=' -Wall -Werror=pointer-arith -Wextra -Wc++-compat -Wwrite-strings -Werror=declaration-after-statement'
ccstdflags=' -std=c89'
EOVIRTUAL
eval {
	# do not have hairy conniptions if this isnt available
	require 'Config_git.pl';
	$Config_SH_expanded .= $Config::Git_Data;
	1;
} or warn "Warning: failed to load Config_git.pl, something strange about this perl...\n";

# Search for it in the big string
sub fetch_string {
    my($self, $key) = @_;

    return undef unless $Config_SH_expanded =~ /\n$key=\'(.*?)\'\n/s;
    # So we can say "if $Config{'foo'}".
    $self->{$key} = $1 eq 'undef' ? undef : $1;
}

my $prevpos = 0;

sub FIRSTKEY {
    $prevpos = 0;
    substr($Config_SH_expanded, 1, index($Config_SH_expanded, '=') - 1 );
}

sub NEXTKEY {
    my $pos = index($Config_SH_expanded, qq('\n), $prevpos) + 2;
    my $len = index($Config_SH_expanded, "=", $pos) - $pos;
    $prevpos = $pos;
    $len > 0 ? substr($Config_SH_expanded, $pos, $len) : undef;
}

sub EXISTS {
    return 1 if exists($_[0]->{$_[1]});

    return(index($Config_SH_expanded, "\n$_[1]='") != -1
          );
}

sub STORE  { die "\%Config::Config is read-only\n" }
*DELETE = *CLEAR = \*STORE; # Typeglob aliasing uses less space

sub config_sh {
    substr $Config_SH_expanded, 1, $config_sh_len;
}

sub config_re {
    my $re = shift;
    return map { chomp; $_ } grep eval{ /^(?:$re)=/ }, split /^/,
    $Config_SH_expanded;
}

sub config_vars {
    # implements -V:cfgvar option (see perlrun -V:)
    foreach (@_) {
	# find optional leading, trailing colons; and query-spec
	my ($notag,$qry,$lncont) = m/^(:)?(.*?)(:)?$/;	# flags fore and aft, 
	# map colon-flags to print decorations
	my $prfx = $notag ? '': "$qry=";		# tag-prefix for print
	my $lnend = $lncont ? ' ' : ";\n";		# line ending for print

	# all config-vars are by definition \w only, any \W means regex
	if ($qry =~ /\W/) {
	    my @matches = config_re($qry);
	    print map "$_$lnend", @matches ? @matches : "$qry: not found"		if !$notag;
	    print map { s/\w+=//; "$_$lnend" } @matches ? @matches : "$qry: not found"	if  $notag;
	} else {
	    my $v = (exists $Config::Config{$qry}) ? $Config::Config{$qry}
						   : 'UNKNOWN';
	    $v = 'undef' unless defined $v;
	    print "${prfx}'${v}'$lnend";
	}
    }
}

# Called by the real AUTOLOAD
sub launcher {
    undef &AUTOLOAD;
    goto \&$Config::AUTOLOAD;
}

1;
