// FlashKeyToolDlg.cpp : implementation file
//

#include "stdafx.h"
#include "FlashKeyTool.h"
#include "FlashKeyToolDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

UINT ThreadScanDevice(LPVOID lpParam)
{
	CFlashKeyToolDlg* pMainDlg = (CFlashKeyToolDlg*)lpParam;
	pMainDlg->ScanDeviceProc();
	return 0;
}
UINT ThreadReadKey(LPVOID lpParam)
{
	CFlashKeyToolDlg* pMainDlg = (CFlashKeyToolDlg*)lpParam;
	pMainDlg->ReadKeyProc();
	return 0;
}
UINT ThreadWriteKey(LPVOID lpParam)
{
	CFlashKeyToolDlg* pMainDlg = (CFlashKeyToolDlg*)lpParam;
	pMainDlg->WriteKeyProc();
	return 0;
}
UINT ThreadReadFlashIDData(LPVOID lpParam)
{
	CFlashKeyToolDlg* pMainDlg = (CFlashKeyToolDlg*)lpParam;
	pMainDlg->ReadFlashUIDDataProc();
	return 0;
}

// CEfuseTestToolDlg dialog
CFlashKeyToolDlg::CFlashKeyToolDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CFlashKeyToolDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CFlashKeyToolDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_STATIC_DEVICE, m_labelDevice);
}

BEGIN_MESSAGE_MAP(CFlashKeyToolDlg, CDialog)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_WM_CLOSE()
	ON_BN_CLICKED(IDC_BTN_BROWSE, &CFlashKeyToolDlg::OnBnClickedBtnBrowse)
	ON_BN_CLICKED(IDC_BTN_READKEY, &CFlashKeyToolDlg::OnBnClickedBtnReadkey)
	ON_BN_CLICKED(IDC_BTN_WRITEKEY, &CFlashKeyToolDlg::OnBnClickedBtnWritekey)
	ON_BN_CLICKED(IDC_BTN_READDATA, &CFlashKeyToolDlg::OnBnClickedBtnReadFlashIDdata)
	ON_BN_CLICKED(IDC_BTN_SWTDEV, &CFlashKeyToolDlg::OnBnClickedBtnSwtdev)
END_MESSAGE_MAP()

void CFlashKeyToolDlg::ScanDeviceProc()
{
	m_pScanEventObject = new CEvent(FALSE,TRUE);
	m_pScanEventObject->ResetEvent();
	m_nDeviceCount = 0;
	m_bExistMsc = FALSE;
	m_bExistAdb = FALSE;
	PSTRUCT_DEVICE_DESC pDevs = NULL;
	while (!m_bTerminated)
	{
		m_csScanLock.Lock();
		m_nDeviceCount=RK_ScanDevice(&pDevs);
		m_csScanLock.Unlock();
		if (m_nDeviceCount==0)
		{
			m_labelDevice.SetText(_T("No Found Device"));
		}
		else if (m_nDeviceCount==1)
		{
			if (pDevs[0].emUsbType==0x04)
			{
				m_bExistMsc = TRUE;
				m_labelDevice.SetText(_T("Found One Msc"));
			}
			else if (pDevs[0].emUsbType==0x8)
			{
				m_bExistAdb = TRUE;
				m_labelDevice.SetText(_T("Found One Adb"));
			}
			else if (pDevs[0].emUsbType==0x1)
			{
				m_bExistMsc = FALSE;
				m_labelDevice.SetText(_T("Found One Maskrom"));

				//m_DeviceEvent.SetEvent();
			}
			else if (pDevs[0].emUsbType==0x2)
			{
				m_bExistMsc = FALSE;
				m_labelDevice.SetText(_T("Found One Loader"));
			}
			else
			{
				m_labelDevice.SetText(_T("Found One Unknown device"));
			}
		}
		else if (m_nDeviceCount>1)
		{
			m_labelDevice.SetText(_T("Found Many Devices"));
		}
		Sleep(200);
	}

	m_pScanEventObject->SetEvent();
}
BOOL CFlashKeyToolDlg::CheckBeforeAction()
{
	BOOL bSuccess=FALSE;
	CString strError=_T("");
	CString strSize;
	USHORT usSize;
	m_csScanLock.Lock();
	if (m_nDeviceCount==0)
	{
		strError = _T("No device!");
		goto Exit_CheckBeforeAction;
	}
	if (m_nDeviceCount>1)
	{
		strError = _T("Many devices!");
		goto Exit_CheckBeforeAction;
	}
	if (m_bExistMsc)
	{
		strError = _T("Msc did not support to do action!");
		goto Exit_CheckBeforeAction;
	}
	else if (m_bExistAdb)
	{
		strError = _T("Adb did not support to do action!");
		goto Exit_CheckBeforeAction;
	}
	if (m_curAction==EM_ACTION_READ_DATA)
	{
		GetDlgItemText(IDC_EDIT_READSIZE,strSize);
		usSize = cmNumString::StrToULong(strSize,0);
		if ((usSize==0)||(usSize>512))
		{
			strError = _T("Value of read size is invalid!");
			goto Exit_CheckBeforeAction;
		}
	}
	if (m_curAction==EM_ACTION_WRITE_DATA)
	{
		GetDlgItemText(IDC_EDIT_WRITESIZE,strSize);
		usSize = cmNumString::StrToULong(strSize,0);
		if ((usSize==0)||(usSize>512))
		{
			strError = _T("Value of write size is invalid!");
			goto Exit_CheckBeforeAction;
		}
	}

	bSuccess = TRUE;
Exit_CheckBeforeAction:
	m_csScanLock.Unlock();
	if (!bSuccess)
	{
		MessageBox(strError,NULL,MB_OK|MB_ICONERROR);
	}
	return bSuccess;
}

/*
BOOL CFlashKeyToolDlg::ReadKeyProc()
{
	BOOL bSuccess=FALSE;
	BYTE Key[32];
	USHORT usKeySize;
	CString strKeyText,strHex;
	int i;
	m_csScanLock.Lock();
	
	if (!RK_ReadKeyHashFromEfuse(Key,usKeySize))
	{
		m_csScanLock.Unlock();
		goto Exit_ReadKey;
	}
	m_csScanLock.Unlock();
	strKeyText = _T("Key:\r\n");
	for (i=0;i<usKeySize;i++)
	{
		strHex.Format(_T("%02X"),Key[i]);
		strKeyText += strHex;
		if (((i+1)%8)!=0)
		{
			strKeyText += _T(" ");
		}
		else
		{
			if ((i+1)<usKeySize)
			{
				strKeyText += _T("\r\n");
			}
		}
	}
	SetDlgItemText(IDC_EDIT_DATA,strKeyText);
	bSuccess = TRUE;
Exit_ReadKey:
	EnableCtrl();
	m_curAction = EM_ACTION_NONE;
	if (bSuccess)
	{
		MessageBox(_T("Reading key ok."));
	}
	else
		MessageBox(_T("Reading key failed!"),NULL,MB_OK|MB_ICONERROR);

	return bSuccess;
}
*/

BOOL CFlashKeyToolDlg::ReadKeyProc()
{
	BOOL bSuccess=FALSE;
	BYTE Key[128];
	USHORT usKeySize = 128;
	CString strKeyText,strHex;
	int i;
	PSTRUCT_DEVICE_DESC pDevs = NULL;
	BOOL bRet;
	CString strCustomID;
	USHORT usCusID;

	m_csScanLock.Lock();

	GetDlgItemText(IDC_EDIT_CUS_ID, strCustomID);
	if (strCustomID.IsEmpty())
	{
		if (m_pLog)
			m_pLog->Record(_T("Custom ID is empty! must provide fail!"));

		EnableCtrl();
		m_curAction = EM_ACTION_NONE;
		MessageBox(_T("Custom ID is empty, Pls input a custom ID!"),NULL,MB_OK|MB_ICONERROR);
		m_csScanLock.Unlock();
		return bSuccess;
	}

	usCusID = cmNumString::StrToULong(strCustomID, 0);

	if (usCusID < 0 || (usCusID > 0 && usCusID < 5))
	{
		if (m_pLog)
		{
			m_pLog->Record(_T("CustomID %d is not correct!!!"), usCusID);
		}
		m_csScanLock.Unlock();
		goto Exit_ReadKey;
	}

	if (!m_bDownBoot)
	{
		bRet = RK_DownloadBoot();
		if (!bRet)
		{
			if (m_pLog)
			{
				m_pLog->Record(_T("Error:RK_DownloadBoot failed."));
			}
			m_csScanLock.Unlock();
			goto Exit_ReadKey;
		}
		m_bDownBoot = TRUE;
		m_nDeviceCount=RK_ScanDevice(&pDevs);

		if (m_pLog)
			m_pLog->Record(_T("RK_DownloadBoot OK."));
	}

	bRet = RK_ReadProvisioningData(usCusID, Key, usKeySize);
	if (!bRet) {
		if (m_pLog)
			m_pLog->Record(_T("RK_ReadProvisioningData fail !"));

		m_csScanLock.Unlock();
		goto Exit_ReadKey;
	}

	if (!RK_ResetRockusb()) {
		m_csScanLock.Unlock();
		goto Exit_ReadKey;
	}
	m_bDownBoot = FALSE;

	m_csScanLock.Unlock();
	strKeyText = _T("Read device Key:\r\n");
	for (i=0;i<usKeySize;i++)
	{
		strHex.Format(_T("%02X"),Key[i]);
		strKeyText += strHex;
		/*
		if (((i+1)%8)!=0)
		{
			strKeyText += _T(" ");
		}
		else
		{
			if ((i+1)<usKeySize)
			{
				strKeyText += _T("\r\n");
			}
		}
		*/
	}

	if (m_pLog)
	{
		m_pLog->Record(_T("read size %d"), usKeySize);
		m_pLog->Record(_T("%s"), strKeyText.Mid(strKeyText.Find('\n') + 1));
	}

	SetDlgItemText(IDC_EDIT_DATA,strKeyText);
	bSuccess = TRUE;

Exit_ReadKey:
	EnableCtrl();
	m_curAction = EM_ACTION_NONE;
	if (bSuccess)
	{
		MessageBox(_T("Reading key ok."));
	}
	else
		MessageBox(_T("Reading key failed!"),NULL,MB_OK|MB_ICONERROR);

	return bSuccess;
}

BOOL CFlashKeyToolDlg::WriteKeyProc()
{
	BOOL bSuccess=FALSE;
	PSTRUCT_DEVICE_DESC pDevs = NULL;
	CString strCustomID;
	USHORT usCusID;
	BOOL bRet;
	int i;

	memset(m_uid, 0, sizeof(m_uid));
	memset(m_Key, 0, sizeof(m_Key));
	m_csScanLock.Lock();

	/**
	* According to flash UID to caculate device key.
	**/
	PBYTE pData=NULL;
	USHORT usSize = 64;	// 8BYTE
	pData =  new BYTE[usSize];
	if (!RK_ReadDataFromEfuse(pData, 0, usSize))		
	{
		m_csScanLock.Unlock();
		goto Exit_WriteKey;
	}
	m_nDeviceCount=RK_ScanDevice(&pDevs);
	FormatFlashUIDData(usSize, pData); // for format flash UID
	m_bDownBoot = TRUE;

	if (!m_flashUID.IsEmpty())
	{
		//////////////////////////////////////////////////////////////////////////
		//TODO: we have get the flash UUID in m_uid in byte, and CString in m_flashUID
		// add your process about flash UID below.
		//...

		/* below just for test, use flash UID as device Key. */
		//-------------------------------------------------------------------
		for(i = 0; i < sizeof(m_uid); i++)
			m_Key[i] = m_uid[i];

		m_deviceKey.Empty();
		for (i = 0; i < sizeof(m_Key); i++)
			m_deviceKey += cmNumString::NumToStr((int)m_Key[i], 16);
		//-------------------------------------------------------------------
	}
	else
	{
		m_csScanLock.Unlock();
		goto Exit_WriteKey;
	}

	GetDlgItemText(IDC_EDIT_CUS_ID, strCustomID);
	if (strCustomID.IsEmpty())
	{
		m_pLog->Record(_T("Custom ID is empty!!!"));
		m_csScanLock.Unlock();
		goto Exit_WriteKey;
	}
	usCusID = cmNumString::StrToULong(strCustomID, 0);

	if (usCusID < 0 || (usCusID > 0 && usCusID < 5))
	{
		if (m_pLog)
		{
			m_pLog->Record(_T("CustomID %d is not correct!!!"), usCusID);
		}
		m_csScanLock.Unlock();
		goto Exit_WriteKey;
	}
	else
		if (m_pLog)
			m_pLog->Record(_T("Will wirte to Custom ID = %d key string!!!"), usCusID);

	bRet = RK_WriteProvisioningData(usCusID, (PBYTE)m_Key, sizeof(m_Key));
	if (!bRet)
	{
		if (m_pLog)
			m_pLog->Record(_T("RK_WriteProvisioningData fail !"));

		m_csScanLock.Unlock();
		goto Exit_WriteKey;
	}

	if (!RK_ResetRockusb()) {
		m_csScanLock.Unlock();
		goto Exit_WriteKey;
	}
	
	m_bDownBoot = FALSE;
	m_csScanLock.Unlock();
	bSuccess = TRUE;

Exit_WriteKey:
	EnableCtrl();
	m_curAction = EM_ACTION_NONE;
	if (bSuccess)
	{
		MessageBox(_T("Writing key ok."));
		if (m_pLog)
			m_pLog->Record(_T("Write Key Success!  key:%s"), m_deviceKey);
	}
	else
		MessageBox(_T("Writing key failed!"),NULL,MB_OK|MB_ICONERROR);

	if (pData)
	{
		delete[] pData;
	}
	return bSuccess;
}

BOOL CFlashKeyToolDlg::ReadFlashUIDDataProc()
{
	BOOL bSuccess=FALSE;
	CString strPos,strSize;
	USHORT usPos,usSize;
	PBYTE pData=NULL;
	GetDlgItemText(IDC_EDIT_READPOS,strPos);
	GetDlgItemText(IDC_EDIT_READSIZE,strSize);
	usPos = 0;//cmNumString::StrToULong(strPos,0);
	usSize = 64; //cmNumString::StrToULong(strSize,0);   /*Flash UID 8Bytes, 64bits*/
	m_csScanLock.Lock();
	pData = new BYTE[usSize];
	if (!pData)
	{
		m_csScanLock.Unlock(); 
		goto Exit_ReadData;
	}
	//if(!RK_ReadEfuse(pData,usSize))
	if (!RK_ReadDataFromEfuse(pData,usPos,usSize))
	{
		m_csScanLock.Unlock();
		goto Exit_ReadData;
	}
	m_csScanLock.Unlock();
	
	//FormatData(usPos,usSize,pData);
	FormatFlashUIDData(usSize, pData);	// for format flash UID [7/18/2020 Chad.ma add]
	bSuccess = TRUE;
Exit_ReadData:
	EnableCtrl();
	m_curAction = EM_ACTION_NONE;
	if (pData)
	{
		delete []pData;
	}
	if (bSuccess)
	{
		MessageBox(_T("Reading data ok."));
	}
	else
		MessageBox(_T("Reading data failed!"),NULL,MB_OK|MB_ICONERROR);

	return bSuccess;
}

// CEfuseTestToolDlg message handlers
void CFlashKeyToolDlg::FormatData(USHORT usPos,USHORT usSize,PBYTE pData)
{
	CString strLine,strIndex,strData;
	int i;
	USHORT usIndex,usOffset=0;
	strLine = strIndex = strData = _T("");
	for (i=0;i<16;i++)
	{
		strLine += cmNumString::NumToStr(i,16);
		if (i<15)
		{
			strLine += _T(" ");
		}
	}
	strData = _T("     ")+strLine+_T("\r\n");
	
	i=usOffset=0;
	usIndex = usPos/16;
	strLine = _T("");
	while (usSize>0)
	{
		if ((usIndex*16+i)<usPos)
		{
			strLine += _T("  ");
		}
		else
		{
			if (pData[usOffset]==0)
			{
				strLine += _T(" 0");
			}
			else
				strLine += _T(" 1");
			usSize--;
			usOffset++;
		}
		i++;
		
		if ((i%16)==0)
		{
			i=0;
			strIndex.Format(_T("%04d"),usIndex);
			strData = strData + strIndex + strLine+_T("\r\n");
			strLine = _T("");
			usIndex++;
		}
	}
	if (!strLine.IsEmpty())
	{
		strIndex.Format(_T("%04d"),usIndex);
		strData = strData + strIndex + strLine;
	}
	SetDlgItemText(IDC_EDIT_DATA,strData);		
}

void CFlashKeyToolDlg::FormatFlashUIDData(USHORT usSize,PBYTE pData)
{
	CString strLine,strIndex,strData;
	int i = 0, idx = 0;
	unsigned char byte_data = 0;
	int byte_num;
	strLine = strIndex = strData = _T("");
#define BYTE_BITS   8

	byte_num = usSize / BYTE_BITS;
	if (usSize % BYTE_BITS != 0)
	{
		MessageBox(_T("data size not correct!"));
		return;
	}

	strData = _T("Flash UID:\r\n");
	strLine = _T(" ");
	while (usSize > 0 )
	{
		for (idx = 0; idx < byte_num; idx ++)
		{
			for (i = 0; i < BYTE_BITS; i++)
			{
				byte_data |= (pData[i + idx * BYTE_BITS] << i);
				byte_data &= 0xFF;
			}

			TRACE("byte_data : 0x%2X \n", byte_data);
			m_uid[idx] = byte_data;
			strData = strData + cmNumString::NumToStr((int)byte_data,16) + strLine;
			usSize -= BYTE_BITS;
			byte_data = 0;
		}
	}
	strData += _T("\r\n");

	m_flashUID.Empty();
	for (idx = 0; idx < byte_num; idx++)
	{
		m_flashUID += cmNumString::NumToStr((int)m_uid[idx],16);
	}

	if (m_pLog)
		m_pLog->Record(_T("Flash UID: %s\r\n"), m_flashUID);

	SetDlgItemText(IDC_EDIT_DATA,strData);
}

BOOL CFlashKeyToolDlg::ParseData(USHORT usSize,PBYTE pData)
{
	CString strSrcData,strLine,strDstData;
	GetDlgItemText(IDC_EDIT_DATA,strSrcData);
	int i=0,pos;
	pos = strSrcData.Find(_T("\r\n"));
	strDstData = _T("");
	while (pos!=-1)
	{
		if (pos<=5)
		{
			return FALSE;
		}
		strLine = strSrcData.Mid(5,pos-5);
		strSrcData = strSrcData.Mid(pos+2);
		if (i>0)
		{
			strLine.Remove(_T(' '));
			strDstData += strLine;
		}
		i++;
		pos = strSrcData.Find(_T("\r\n"));
	}
	if ((i>0)&&(strSrcData.GetLength()>5))
	{
		strLine = strSrcData.Mid(5);
		strLine.Remove(_T(' '));
		strDstData += strLine;
		strSrcData = _T("");
	}
	if (strDstData.GetLength()!=usSize)
	{
		TRACE(_T("len:%d\r\n"),strDstData.GetLength());
		return FALSE;
	}
	for(i=0;i<usSize;i++)
	{
		if (strDstData[i]==_T('0'))
		{
			pData[i] = 0;
		}
		else if (strDstData[i]==_T('1'))
		{
			pData[i] = 1;
		}
		else
			return FALSE;	
	}
	return TRUE;
}

BOOL CFlashKeyToolDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here
	/* Caption */
	CString dlgTitle;
	GetWindowText(dlgTitle);
	dlgTitle += APP_VERSION;
	SetWindowText((LPCTSTR)dlgTitle);

	m_strModulePath = cmPath::GetModulePath();
	m_strLogPath = m_strModulePath + _T("Log\\");
	m_pScanEventObject = NULL;
	m_pScanThreadObject = NULL;
	m_bUpgradeDllInitOK = FALSE;
	m_bTerminated = FALSE;
	m_curAction = EM_ACTION_NONE;
	if ( !cmFile::IsExisted(m_strLogPath) )
	{
		CreateDirectory(m_strLogPath,NULL);
	}
	//Initialize RKupgrade dll
	INIT_DEV_INFO InitDevInfo;
	INIT_LOG_INFO InitLogInfo;
	INIT_CALLBACK_INFO InitCallbackInfo;

	InitDevInfo.bScan4FsUsb = TRUE;
	InitDevInfo.emSupportDevice = 0;
	InitDevInfo.uiRockMscTimeout = 20;
	InitDevInfo.uiRockusbTimeout = 20;
	InitDevInfo.usRockMscPid = 0;
	InitDevInfo.usRockMscVid = 0;
	InitDevInfo.usRockusbPid = 0;
	InitDevInfo.usRockusbVid = 0;

	InitLogInfo.bLogEnable = TRUE;
	InitLogInfo.lpszLogPathName = (LPTSTR)(LPCTSTR)m_strLogPath;

	InitCallbackInfo.pProgressPromptProc = NULL;//you can set it to ProgressPromptProc for showing upgrade info;
	InitCallbackInfo.pUpgradeStepPromptProc = NULL;//you can set it to UpgradeStepPromptProc for showing progress info;

	m_bUpgradeDllInitOK = RK_Initialize(InitDevInfo, InitLogInfo, InitCallbackInfo);
	if (!m_bUpgradeDllInitOK)
	{
		MessageBox(_T("Initialize RKUpgrade dll failed!"),_T("ERROR"),MB_ICONERROR|MB_OK);
	}
	else
	{
		m_pScanThreadObject = AfxBeginThread(ThreadScanDevice,(LPVOID)this);
	}

	BOOL bRet = FALSE;
	m_pLog = NULL;
	m_pLog = new cmLog(m_strLogPath, bRet);
	if (!bRet)
	{
		if(m_pLog)
		{
			delete m_pLog;
			m_pLog = NULL;
		}
	}

	m_bDownBoot = FALSE;
	memset(m_uid, 0, sizeof(m_uid));
	memset(m_Key, 0, sizeof(m_Key));

	m_labelDevice.SetParent(this);
	m_labelDevice.SetFontSize(15).SetFontBold(TRUE);
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CFlashKeyToolDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CFlashKeyToolDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}


void CFlashKeyToolDlg::OnClose()
{
	// TODO: Add your message handler code here and/or call default
	if (m_curAction!=EM_ACTION_NONE)
	{
		MessageBox(_T("Action is not finished,please close later!"),NULL,MB_OK|MB_ICONERROR);
		return;
	}

	if (m_bTerminated)
	{
		return ;
	}
	m_bTerminated = TRUE;
	if (m_pScanThreadObject)
	{
		MSG msg;
		DWORD dwRet;
		while (TRUE)
		{
			dwRet = MsgWaitForMultipleObjects(1, &m_pScanEventObject->m_hObject,FALSE, 10000, QS_ALLINPUT);
			if(WAIT_OBJECT_0 ==dwRet )
			{
				break;
			}
			else if( (WAIT_OBJECT_0+1)==dwRet )
			{
				while (PeekMessage(&msg, NULL, NULL, NULL, PM_REMOVE))
				{
					TranslateMessage(&msg);
					DispatchMessage(&msg);
				}

			}
			else if (WAIT_TIMEOUT==dwRet)
			{
				TerminateThread(m_pScanThreadObject->m_hThread,0);
				break;
			}
		}//end while
		m_pScanThreadObject = NULL;
		delete m_pScanEventObject;
		m_pScanEventObject = NULL;
	}
	if (m_bUpgradeDllInitOK)
	{
		RK_Uninitialize();
	}
	CDialog::OnCancel();
}
void CFlashKeyToolDlg::EnableCtrl()
{
	GetDlgItem(IDC_BTN_BROWSE)->EnableWindow(TRUE);
	GetDlgItem(IDC_BTN_READKEY)->EnableWindow(TRUE);
	GetDlgItem(IDC_BTN_READDATA)->EnableWindow(TRUE);
	GetDlgItem(IDC_BTN_WRITEKEY)->EnableWindow(TRUE);
	GetDlgItem(IDC_EDIT_DATA)->EnableWindow(TRUE);
}
void CFlashKeyToolDlg::DisableCtrl()
{
	GetDlgItem(IDC_BTN_BROWSE)->EnableWindow(FALSE);
	GetDlgItem(IDC_BTN_READKEY)->EnableWindow(FALSE);
	GetDlgItem(IDC_BTN_READDATA)->EnableWindow(FALSE);
	GetDlgItem(IDC_BTN_WRITEKEY)->EnableWindow(FALSE);
	GetDlgItem(IDC_EDIT_DATA)->EnableWindow(FALSE);
}
void CFlashKeyToolDlg::OnBnClickedBtnBrowse()
{
	// TODO: Add your control notification handler code here
	BOOL bRet;
	CString strFile,strFilter;
	strFilter = _T("Firmware(*.img)|*.img|Loader(*.bin)|*.bin||");
	bRet = cmCommonDlg::OpenDialog(strFile,strFilter);
	if (bRet)
	{
		bRet = RK_SetFirmware(strFile);
		if (!bRet)
		{
			MessageBox(_T("Loading firmware failed!"),_T("ERROR"),MB_ICONERROR|MB_OK);
			SetDlgItemText(IDC_EDIT_FW,_T(""));
		}
		else
			SetDlgItemText(IDC_EDIT_FW,strFile);
	}
}

void CFlashKeyToolDlg::OnBnClickedBtnReadkey()
{
	// TODO: Add your control notification handler code here
	DisableCtrl();
	m_curAction = EM_ACTION_READ_KEY;
	if (!CheckBeforeAction())
	{
		EnableCtrl();
		m_curAction = EM_ACTION_NONE;
		return;
	}
	SetDlgItemText(IDC_EDIT_DATA,_T(""));
	AfxBeginThread(ThreadReadKey,(LPVOID)this);
}

void CFlashKeyToolDlg::OnBnClickedBtnWritekey()
{
	// TODO: Add your control notification handler code here
	DisableCtrl();
	m_curAction = EM_ACTION_WRITE_KEY;
	if (!CheckBeforeAction())
	{
		EnableCtrl();
		m_curAction = EM_ACTION_NONE;
		return;
	}
	SetDlgItemText(IDC_EDIT_DATA,_T(""));
	AfxBeginThread(ThreadWriteKey,(LPVOID)this);
}

BOOL CFlashKeyToolDlg::PreTranslateMessage(MSG* pMsg)
{
	// TODO: Add your specialized code here and/or call the base class
	if ( pMsg->message==WM_KEYDOWN && pMsg->wParam==VK_ESCAPE )
	{
		return TRUE;
	}
	if ( pMsg->message==WM_KEYDOWN && pMsg->wParam==VK_RETURN )
	{
		return TRUE;
	}
	return CDialog::PreTranslateMessage(pMsg);
}

void CFlashKeyToolDlg::OnBnClickedBtnReadFlashIDdata()
{
	// TODO: Add your control notification handler code here
	DisableCtrl();
	m_curAction = EM_ACTION_READ_DATA;
	//if (!CheckBeforeAction())
	//{
	//	EnableCtrl();
	//	m_curAction = EM_ACTION_NONE;
	//	return;
	//}

	SetDlgItemText(IDC_EDIT_DATA,_T(""));
	AfxBeginThread(ThreadReadFlashIDData,(LPVOID)this);
}

void CFlashKeyToolDlg::OnBnClickedBtnSwtdev()
{
	// TODO: Add your control notification handler code here
	BOOL bSuccess=FALSE;
	CString strError=_T("");

	DisableCtrl();

	m_csScanLock.Lock();
	if (m_nDeviceCount==0)
	{
		strError = _T("No device!");
		goto Exit_SwitchDev;
	}
	if (m_nDeviceCount>1)
	{
		strError = _T("Many devices!");
		goto Exit_SwitchDev;
	}

	if (m_bExistMsc)
	{
		RK_SwitchToRockusb(0);	//лmaskromģʽ
	}
	else
	{
		strError = _T("None Msc device!");
		goto Exit_SwitchDev;
	}

	bSuccess = TRUE;

Exit_SwitchDev:
	m_csScanLock.Unlock();

	if (!bSuccess)
		MessageBox(strError,NULL,MB_OK|MB_ICONERROR);

	EnableCtrl();
	return;
}
