// FlashKeyToolDlg.h : header file
//

#pragma once

#include "cmPath.h"
#include "cmFile.h"
#include "cmNumString.h"
#include "cmCommonDlg.h"
#include "cmStrCode.h"
#include "afxwin.h"
#include "Label.h"
#include "cmLog.h"

using namespace cm;

typedef enum{
	EM_ACTION_NONE=0,
	EM_ACTION_READ_KEY,
	EM_ACTION_WRITE_KEY,
	EM_ACTION_READ_DATA,
	EM_ACTION_WRITE_DATA
}EM_ACTION;
// CEfuseTestToolDlg dialog
class CFlashKeyToolDlg : public CDialog
{
// Construction
public:
	CFlashKeyToolDlg(CWnd* pParent = NULL);	// standard constructor
	void ScanDeviceProc();
	BOOL ReadKeyProc();
	BOOL WriteKeyProc();
	BOOL ReadFlashUIDDataProc();
// Dialog Data
	enum { IDD = IDD_EFUSETESTTOOL_DIALOG };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	
// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	virtual BOOL OnInitDialog();
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	DECLARE_MESSAGE_MAP()
private:
	CString m_strModulePath;
	CString m_strLogPath;
	BOOL m_bUpgradeDllInitOK;
	CWinThread *m_pScanThreadObject;
	CEvent *m_pScanEventObject;
	CCriticalSection m_csScanLock;
	UINT m_nDeviceCount;
	BOOL m_bExistMsc;
	BOOL m_bExistAdb;
	BOOL m_bTerminated;
	EM_ACTION m_curAction;
	
	/* Flash UID */
	CString m_flashUID;
	CString m_deviceKey;
	BYTE m_uid[8];
	BYTE m_Key[32];
	cmLog *m_pLog;
	BOOL m_bDownBoot;

	void DisableCtrl();
	void EnableCtrl();
	BOOL CheckBeforeAction();
	void FormatData(USHORT usPos,USHORT usSize,PBYTE pData);
	void FormatFlashUIDData(USHORT usSize,PBYTE pData);
	BOOL ParseData(USHORT usSize,PBYTE pData);
public:
	afx_msg void OnClose();
	CLabel m_labelDevice;
	afx_msg void OnBnClickedBtnBrowse();
	afx_msg void OnBnClickedBtnReadkey();
	afx_msg void OnBnClickedBtnWritekey();
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	afx_msg void OnBnClickedBtnReadFlashIDdata();
	afx_msg void OnBnClickedBtnSwtdev();
};
