chrome.runtime.onInstalled.addListener(() => {
    console.log('智能网申助手已安装');
});

chrome.action.onClicked.addListener((tab) => {
    chrome.action.openPopup();
});

chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
    if (request.action === 'parseResume') {
        parseResumeFile(request.data)
            .then(result => sendResponse({ success: true, data: result }))
            .catch(error => sendResponse({ success: false, error: error.message }));
        return true;
    }
});

async function parseResumeFile(fileData) {
    try {
        const mockResult = {
            name: extractName(fileData),
            phone: extractPhone(fileData),
            email: extractEmail(fileData),
            school: extractSchool(fileData),
            major: extractMajor(fileData),
            education: extractEducation(fileData),
            experiences: extractExperiences(fileData),
            awards: extractAwards(fileData)
        };
        
        return mockResult;
    } catch (error) {
        throw new Error('简历解析失败: ' + error.message);
    }
}

function extractName(text) {
    const namePatterns = [
        /姓[\s]*名[\s]*[：:]\s*([^\n\r\s]{2,4})/,
        /姓[\s]*名[\s]*([^\n\r\s]{2,4})/,
        /^([^\n\r\s]{2,4})$/m
    ];
    
    for (const pattern of namePatterns) {
        const match = text.match(pattern);
        if (match) return match[1];
    }
    
    return '';
}

function extractPhone(text) {
    const phonePattern = /(1[3-9]\d{9})/;
    const match = text.match(phonePattern);
    return match ? match[1] : '';
}

function extractEmail(text) {
    const emailPattern = /([a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,})/;
    const match = text.match(emailPattern);
    return match ? match[1] : '';
}

function extractSchool(text) {
    const schoolPatterns = [
        /(?:毕业院校|学校|院校)[：:\s]*([^\n\r,，。]{2,20}(?:大学|学院|学校))/,
        /([^\n\r,，。]{2,20}(?:大学|学院|学校))/
    ];
    
    for (const pattern of schoolPatterns) {
        const match = text.match(pattern);
        if (match) return match[1];
    }
    
    return '';
}

function extractMajor(text) {
    const majorPatterns = [
        /(?:专业|所学专业)[：:\s]*([^\n\r,，。]{2,20})/,
        /([^\n\r,，。]*(?:工程|科学|技术|管理|设计|艺术|文学|法学|医学|教育)[^\n\r,，。]*)/
    ];
    
    for (const pattern of majorPatterns) {
        const match = text.match(pattern);
        if (match) return match[1];
    }
    
    return '';
}

function extractEducation(text) {
    if (text.includes('博士') || text.includes('PhD')) return '博士';
    if (text.includes('硕士') || text.includes('研究生') || text.includes('Master')) return '硕士';
    if (text.includes('本科') || text.includes('学士') || text.includes('Bachelor')) return '本科';
    if (text.includes('专科') || text.includes('大专')) return '专科';
    
    return '';
}

function extractExperiences(text) {
    const experiences = [];
    const expSections = text.split(/(?:实习经历|工作经历|项目经历)/i);
    
    if (expSections.length > 1) {
        const expText = expSections[1];
        const companies = expText.match(/([^\n\r]{2,20}(?:公司|科技|集团|企业|有限公司|股份有限公司))/g);
        
        if (companies && companies.length > 0) {
            companies.slice(0, 3).forEach(company => {
                experiences.push({
                    company: company,
                    position: '实习生',
                    duration: '2023.06-2023.09',
                    description: '参与项目开发和维护工作'
                });
            });
        }
    }
    
    return experiences;
}

function extractAwards(text) {
    const awardPatterns = [
        /(?:获奖情况|荣誉奖项|获奖经历)[：:\s]*([^\n\r]{10,100})/,
        /((?:[^\n\r]*(?:奖学金|奖|优秀|竞赛)[^\n\r]*[\n\r]*){1,3})/
    ];
    
    for (const pattern of awardPatterns) {
        const match = text.match(pattern);
        if (match) return match[1].replace(/[\n\r]+/g, '、').trim();
    }
    
    return '';
}