import sys
import mwxml

def parse_large_dump(file_path):
    dump = mwxml.Dump.from_file(open(file_path, 'rb'))
    for page in dump.pages:
        for revision in page:
            title = page.title
            text = revision.text or ""
            print("=" * 80)
            print(f"Title: {title}")
            print(f"Text: {text[:200]}...\n")

def main():
    if len(sys.argv) != 2:
        print("Usage: python parse_wiki_dump.py <wiki_dump.xml>")
        sys.exit(1)

    file_path = sys.argv[1]
    parse_large_dump(file_path)

if __name__ == "__main__":
    main()
